import * as React from 'react';

import { Dict } from '../../../../../types';
import { Button } from '../../../../ui/Button';
import Checkbox from '../../../../ui/Checkbox';
import mainStyles from '../../../../ui/index.css';
import { FormConstructor } from '../../../FormConstructor';
import { SimpleError } from '../../../SimpleError';
import Spin from '../../../Spin';
import coreStyles from '../index.css';
import { existingTagSchema } from '../schemas/existingTagSchema';
import { PROMOCODE_WIZARD_ROUTE } from '../types';
import styles from './index.css';

interface IGeneratorFormProps {
    error: Error | null;
    progress: {title: string; isLoading: boolean} | null;
    title?: string;
    tagSchema: Dict<any>;
    onChangeTag: () => void;
    actionSchema: Dict<any>;
    onChangeAction: () => void;
    onSubmit: (tagName) => void;
    changeStep: () => void;
}

export const GeneratorForm = (props: IGeneratorFormProps) => {
    const {
        title = null,
        tagSchema,
        onChangeTag,
        actionSchema,
        onChangeAction,
        onSubmit,
        error,
        progress,
        changeStep,
    } = props;
    const [useExistingTag, shouldUseExistingTag] = React.useState(false);
    const [data, onChange] = React.useState(null);

    return (
        <div className={coreStyles.pw_container}>
            <div className={coreStyles.pw_wrapper}>
                {error && <SimpleError className={coreStyles.error}
                                       error={error}/>}
                {progress && (
                    <p className={styles.existingTag}>
                        <span className={styles.control}>
                            {progress?.title}
                        </span>
                        {progress?.isLoading && <Spin size={'s'}/>}
                    </p>
                )}
                {title && <p>{title}</p>}
                <p className={styles.existingTag}>
                    <Checkbox className={styles.control}
                              checked={useExistingTag}
                              onChange={shouldUseExistingTag.bind(null, !useExistingTag)}/> выбрать существующий тег
                </p>
                {useExistingTag
                    ? <FormConstructor schema={existingTagSchema}
                                       onChange={onChange.bind(null)}/>
                    : <FormConstructor schema={tagSchema}
                                       onChange={onChangeTag.bind(null)}/>
                }
                <FormConstructor schema={actionSchema}
                                 onChange={onChangeAction.bind(null)}/>
                <div className={mainStyles.button_container}>
                    <Button onClick={onSubmit.bind(null, data)}>Создать</Button>
                    {progress && !progress?.isLoading && (
                        <Button onClick={changeStep.bind(null, PROMOCODE_WIZARD_ROUTE.promo)}
                                basic>+ промо с созданным генератором</Button>
                    )}
                </div>
            </div>
        </div>
    );
};
