import * as React from 'react';

import { SimpleError } from '../../../SimpleError';
import { AddPromo } from '../../Promo/AddPromo';
import * as coreStyles from '../index.css';

export const PromocodeForm = (props: {newGenerator?: string[]}) => {
    const [error, setError] = React.useState(null);
    const [isFinished, setFinished] = React.useState<string | null>(null);

    const afterFetch = () => {
        setFinished('Серия промокодов добавлена ✅');
    };

    return (
        <div className={coreStyles.pw_container}>
            <div className={coreStyles.pw_wrapper}>
                {error && <SimpleError error={error}
                                       className={coreStyles.error}/>}
                {isFinished && <p>{isFinished}</p>}

                <AddPromo newGenerator={props.newGenerator}
                          setError={setError.bind(null)}
                          afterFetch={afterFetch.bind(null)}/>
            </div>
        </div>
    );
};
