import { IComponentRequest, REQUEST_METHOD } from '../../../utils/request';

export const REQUESTS = {
    ADD_ACTION: 'ADD_ACTION',
    CREATE_TAG: 'CREATE_TAG',
    GET_ACTIONS: 'GET_ACTIONS',
};

export const PW_REQUESTS: IComponentRequest = {
    [REQUESTS.GET_ACTIONS]: {
        api: 'actions/list',
        cgiObj: {
            report: null, //compact
        },
    },
    [REQUESTS.ADD_ACTION]: {
        method: REQUEST_METHOD.POST,
        api: 'actions/add',
    },
    [REQUESTS.CREATE_TAG]: {
        method: REQUEST_METHOD.POST,
        api: 'tag/description/add',
    },
};
