import { controlType } from '../../../FormConstructor/types';

export const PROCENT_TAG_SCHEMA = {
    name: {
        type: controlType.string,
        display_name: 'Идентификатор тега для промокода',
        default: '',
        order: 1,
    },
    comment: {
        type: controlType.string,
        display_name: 'Описание промокода',
        default: '',
        order: 2,
    },
    meta: {
        type: controlType.structure,
        structure: {
            action_ids: {
                display_name: 'Идентификатор action offer_builder',
                order: 1,
                type: controlType.variants,
                multi_select: true,
            },
        },
        order: 3,
        display_name: 'Мета',
        __isOpen: true,
    },
};

export const PROCENT_ACTION_SCHEMA = {
    action_id: {
        read_only: false,
        type: 'string',
        order: 1,
        display_name: 'Идентификатор action для промокода',
    },
    attempts_count: {
        type: 'numeric',
        order: 2,
        display_name: 'Количество поездок',
    },
    since: {
        type: 'numeric',
        visual: 'timestamp',
        display_name: 'Дата старта',
        order: 3,
    },
    until: {
        display_name: 'Дата окончания',
        type: 'numeric',
        visual: 'timestamp',
        order: 4,
    },
    first_only: {
        default: false,
        type: 'bool',
        order: 5,
        display_name: 'Только на первые поездки',
    },
};
