import { controlType } from '../../../FormConstructor/types';

export const RUB_TAG_SCHEMA = {
    name: {
        type: controlType.string,
        display_name: 'Идентификатор тега для промокода',
        default: '',
        order: 1,
    },
    comment: {
        type: controlType.string,
        display_name: 'Описание промокода',
        default: '',
        order: 2,
    },
    meta: {
        type: controlType.structure,
        structure: {
            amount: {
                display_name: 'Сумма списания/начисления (копейки)',
                type: 'numeric',
                order: 1,
            },
            deep_history_deep: {
                default: '45d',
                type: 'string',
                display_name: 'Длительность акции',
                visual: 'duration',
                order: 2,
            },
            amount_lifetime: {
                type: 'string',
                visual: 'duration',
                display_name: 'Время жизни суммы',
                order: 3,
            },
            amount_deadline: {
                display_name: 'Время сгорания суммы',
                type: 'numeric',
                visual: 'timestamp',
                order: 4,
            },
            accounts: {
                order: 5,
                type: controlType.variants,
                multi_select: true,
                display_name: 'Доступные для списания аккаунты',
            },
        },
        order: 3,
        display_name: 'Мета',
        __isOpen: true,
    },
};

export const RUB_ACTION_SCHEMA = {
    action_id: {
        read_only: false,
        type: 'string',
        order: 1,
        display_name: 'Идентификатор action для промокода',
    },
    first_only: {
        default: false,
        type: 'bool',
        order: 2,
        display_name: 'Только на первые поездки',
    },
};
