import React, { useState } from 'react';

import { Button } from '../../../ui/Button';
import { Window } from '../../../ui/FullModal';
import TextArea from '../../../ui/TextArea';

interface IProposeCommentModalProps {
    onClose: () => void;
    error: Error | null;
    isWorking: boolean;
    setComment: () => void;
    isRequired?: boolean;
}

export const ProposeCommentModal = React.memo((props: IProposeCommentModalProps) => {
    const [comment, setComment] = useState('');

    return <Window onClose={props.onClose} title={'Предложение...'} error={props.error}>
        <div>
            <TextArea onChange={setComment}
                      value={comment}
                      placeholder={`Комментарий ${props.isRequired ? ' (обязательное поле)' : ''}`}
                      disabled={props.isWorking}/>
        </div>
        <div>
            <Button onClick={props.setComment.bind(null, comment, false)}
                    isLoading={props.isWorking}
                    disabled={Boolean(props.isRequired && !comment)}>
                Предложить
            </Button>
        </div>
    </Window>;
});
