import React from 'react';

import SVGHelper, { createCircle } from '../../../../utils/SVgHelper';

export default function ManualSvg() {
    const ref = React.useRef<SVGSVGElement | null>(null);
    let svg: any = null;

    React.useEffect(() => {
        init();

        return () => {
            svg.destroy();
        };
    }, []);

    const init = () => {
        svg = SVGHelper(ref.current);
        const circle = createCircle({ id: 'circle', cx: 40, cy: 40, r: 20 });
        const circle2 = createCircle({ id: 'circle1', cx: 100, cy: 100, r: 30 });
        const circle3 = createCircle({ id: 'circle2', cx: 40, cy: 250, r: 20 });
        const circle4 = createCircle({ id: 'circle3', cx: 140, cy: 350, r: 15 });

        svg.connect([[circle, circle3], [circle, circle2], [circle3, circle2]]);
        svg.connect([[circle, circle4]]);

        svg.append([circle, circle2, circle3, circle4]);

    };

    return <svg ref={ref}/>;
}
