export class GraphHelper {
    _root = {};
    _map = {};

    constructor(arr) {
        arr.forEach(el => {
            this._map[el.role_id] = el;
        });
    }

    addNode(role) {
        if (role.role_id) {
            this._root[role.role_id] = new GraphNode(role, this._map);
        }
    }

    find(id) {
        const findSlaves = Object.entries(this._root).filter(([, node]: [string, any]) => {
            return node?.node?.role?.slave_roles.some(el => {
                return el.slave_role_id === id;
            });
        });

        return [id, this._root[id], findSlaves];
    }
}

class GraphNode {
    node = {};
    children = [];
    _parents = {};

    constructor(role, map = {}, parents = {}) {
        this._parents = parents;
        const { role_id, role_description, slave_role_id, slave_roles } = role || {};
        this._parents[role_id] = true;
        this.node = { node_id: role_id || slave_role_id, role_description, role };
        this.children = slave_roles?.map(el => {
            if (parents[el.slave_role_id]) {
                return new GraphNode(map[el.slave_role_id]);
            }

            parents[el.slave_role_id] = true;

            return new GraphNode(map[el.slave_role_id], map, this._parents);

        }) || [];
    }
}
