import React from 'react';
import { useLocation } from 'react-router-dom';

import { useRequestHandler } from '../../../hooks/useRequestHandler';
import { Link } from '../../../ui/Link';
import Select from '../../../ui/Select';
import { Request2 } from '../../../utils/request';
import Spin from '../../Spin';
import { REQUESTS, SETTINGS_REQUESTS } from '../request';
import styles from './index.css';
import RoleGraph from './RoleGraph';

const RoleAnalyzer = () => {
    React.useEffect(() => {
        getRoles();
    }, []);
    const [role_id, setRole] = React.useState<string | null>(null);
    const [list, buildList] = React.useState<any[]>([]);
    const location = useLocation();

    React.useEffect(() => {
        const role_id = new URLSearchParams(location.search).get('role_id') || 'dtp_new_flow';
        setRole(role_id);
    }, [location.search]);

    const requestOptions = React.useMemo(() => {
        return {
            requestName: REQUESTS.GET_ROLES,
            requestOptions: {
                queryParams: {},
            },
        };
    }, []);

    const request = new Request2({ requestConfigs: SETTINGS_REQUESTS });

    const [isLoading, response, , getRoles] = useRequestHandler<any>(request, requestOptions);

    const onSelect = (role) => {
        setRole(role);
    };

    const options = response?.report?.length ? response.report.map(el => ({
        value: el.role_id,
        text: el.role_id,
        description: el.role_description,
    })) : [];

    return <div>
        <h4>Role Analyzer {isLoading ? <Spin size={'s'}/> : ''}</h4>
        <div className={styles.component}>
            <div className={styles.section}>
                <RoleGraph roles={response} role_id={role_id} buildList={buildList}/>
            </div>
            <div className={styles.sidebar}>
                <Select onSelect={onSelect}
                        options={options}
                        initialValues={role_id ? [role_id] : []}
                        placeholder={'Фильтр ролей'}/>
                <div>
                    <ul>
                        {
                            list?.map(el => {
                                return <li key={el.id}>
                                    <Link target={'_blank'}
                                          href={`#/settings/roles?role_id=${decodeURIComponent(el.id)}`}>{el.id}</Link>
                                </li>;
                            })
                        }
                    </ul>
                </div>

            </div>
            {/* <div className={styles.section}>
                <ManualSvg/>
            </div>*/}
        </div>
    </div>;
};

export default RoleAnalyzer;
