import * as React from 'react';
import VirtualList from 'react-tiny-virtual-list';

import { useWindowResize } from '../../../hooks/useWindowResize';
import { BallItem } from '../../../ui/GroupingTag';
import { IsChecked } from '../../../ui/IsChecked';
import { Link } from '../../../ui/Link';
import { IPropositions } from './component';
import * as _style from './index.css';

export interface IVirtualRoles {
    report: any[];
    propositions: IPropositions;
    removeRole: () => void;
}

interface IVirtualTrProps {
    item: any;
    style: any;
    index: number;
    propositions: any;
    removeRole: () => void;
}

export const VirtualTr = React.memo((props: IVirtualTrProps) => {
    let { item, style, index, propositions = [], removeRole } = props;
    const role = item;
    const hasProposition = propositions && Array.isArray(propositions) && propositions.length;
    const tooltip = propositions && propositions.map((p) => p.proposition_description).join(';\n');

    return <div style={style} className={`${_style.virtual_tr}`}>
        <span>{++index}</span>
        <span className={`${_style.role_id}`}>
            <div>
                <div>
                    <Link href={`#/settings/roles?role_id=${encodeURIComponent(role.role_id)}`}>{role.role_id}</Link>
                    <span> {
                        hasProposition
                            ? <BallItem onlyBall
                                        tooltip={tooltip}
                                        id={role.role_id + '_proposition'}
                                        text={hasProposition}
                                        className={style.has_propositions}/>
                            : ''}</span>
                </div>
                <div className={_style.sub_roles}>
                    {role?.slave_role_ids?.join(', ')}
                </div>
            </div>

        </span>
        <span>{role.role_group}</span>
        <span title={role.role_description}>{role.role_description}</span>
        <span><IsChecked checked={role.role_is_public}/></span>
        <span><IsChecked checked={role.role_is_idm}/></span>
        <span><IsChecked checked={role.role_optional}/></span>
        <span>
            <Link className={`${style.link} ${_style.handlers}`}
                  disable={Boolean(hasProposition)}
                  href={`#/roles-users/main?roleId=${encodeURIComponent(role.role_id)}`}>
                users
            </Link>
            <Link className={style.link}
                  disable={Boolean(hasProposition)}
                  onClick={removeRole.bind(null, role.role_id)}>
                del
            </Link>
        </span>
    </div>;
});

const HEIGHT_PADDING = 275;

export const VirtualRoles = React.memo((props: IVirtualRoles) => {
    const windowSize = useWindowResize();
    const { report, propositions, removeRole } = props;

    return <VirtualList width={'100%'}
                        height={windowSize.height - HEIGHT_PADDING}
                        itemCount={report.length}
                        itemSize={35}
                        renderItem={({ index, style }) => {
                            return <VirtualTr key={index}
                                              item={report[index]}
                                              style={style}
                                              index={index}
                                              removeRole={removeRole}
                                              propositions={propositions[report[index].role_id]}/>;
                        }}/>;
});
