import React from 'react';

import { Button } from '../../../../ui/Button';
import { Window } from '../../../../ui/FullModal';
import { Request2 } from '../../../../utils/request';
import { download } from '../../../../utils/utils';
import { REQUESTS, SETTINGS_REQUESTS } from '../../request';

interface ISaveUserButtonProps {
    roles: string;
}

interface ISaveUserButtonState {
    isLoading: boolean;
    error: Error | null;
}

export class SaveUserButton extends React.Component<ISaveUserButtonProps, ISaveUserButtonState> {
    state: ISaveUserButtonState = {
        isLoading: false,
        error: null,
    };
    request = new Request2({ requestConfigs: SETTINGS_REQUESTS });

    onSaveUsers() {
        const DEFAULT_PAGE_SIZE = 3000;

        this.setState({ isLoading: true, error: null }, () => {
            this.request.exec(REQUESTS.GET_USERS_BY_ROLE, {
                queryParams: {
                    page_size: DEFAULT_PAGE_SIZE,
                    roles: this.props.roles,
                },
            })
                .then(response => {
                    let csv = 'Фамилия;Имя;Отчество;Username;Status\n';

                    response?.report?.forEach(user => {
                        csv += `${user.first_name};${user.last_name};${user.pn};${user.username};${user.status}\n`;
                    });

                    download(csv, `${this.props.roles}_users.csv`, 'text/csv');

                    this.setState({ isLoading: false });
                })
                .catch(error => {
                    this.setState({
                        isLoading: false,
                        error,
                    });
                });
        });
    }

    closeErrorModal() {
        this.setState({ error: null });
    }

    render() {
        return <>
            <Button onClick={this.onSaveUsers.bind(this)}
                    basic={true}
                    disabled={!this.props.roles}
                    isLoading={this.state.isLoading}>
                Скачать пользователей
            </Button>

            {this.state.error
                ? <Window onClose={this.closeErrorModal.bind(this)}
                          error={this.state.error}
                          title={'Не удалось загрузить роли'}/>
                : null
            }
        </>;
    }
}
