import React from 'react';

import Checkbox from '../../../../ui/Checkbox';
import { CSSettingsItems, CustomSettings } from '../../../../utils/customSettings';
import * as style from '../index.css';

const UserSettings = React.memo((props: any) => {
    const cs = new CustomSettings();
    let customSettings = cs.getSettings() ?? {};

    const setSetting = (key) => {
        customSettings = cs.set(key, !customSettings[key]);
        if ([CSSettingsItems.nightMode].includes(key)) {
            location.reload();
        }
    };

    const showDisableFeedBtn = props.blockRules.ShowDisableFeedBtn;

    return <div className={style.customSettingsContainer}>
        <div className={style.customSettings}>
            <h5>Биллинг</h5>
            <div>
                Раскрывать кошельки по умолчанию
                <Checkbox checked={customSettings[CSSettingsItems.walletsExpanded]}
                          onChange={setSetting.bind(null, CSSettingsItems.walletsExpanded)}/>
            </div>
            <div>
                Раскрывать карты по умолчанию
                <Checkbox checked={customSettings[CSSettingsItems.cardsExpanded]}
                          onChange={setSetting.bind(null, CSSettingsItems.cardsExpanded)}/>
            </div>
            <div>
                Раскрывать данные корпоративного пользователя по умолчанию
                <Checkbox checked={customSettings[CSSettingsItems.userBalanceExpanded]}
                          onChange={setSetting.bind(null, CSSettingsItems.userBalanceExpanded)}/>
            </div>
        </div>
        <div className={style.customSettings}>
            <h5>Треки</h5>
            <div>
                Включать полигоны (как клиент) по умолчанию
                <Checkbox checked={customSettings[CSSettingsItems.showPolyTrack]}
                          onChange={setSetting.bind(null, CSSettingsItems.showPolyTrack)}/>
            </div>
            <div>
                Показывать все треки по умолчанию
                <Checkbox checked={customSettings[CSSettingsItems.showAllTrack]}
                          onChange={setSetting.bind(null, CSSettingsItems.showAllTrack)}/>
            </div>
            <div>
                Показывать Фикс по умолчанию
                <Checkbox checked={customSettings[CSSettingsItems.showFixTrack]}
                          onChange={setSetting.bind(null, CSSettingsItems.showFixTrack)}/>
            </div>
        </div>
        <div className={style.customSettings}>
            <h5>Чаты</h5>
            <div>
                Включить автоматические приветствия/извинения
                <Checkbox checked={customSettings[CSSettingsItems.showWelcomes]}
                          onChange={setSetting.bind(null, CSSettingsItems.showWelcomes)}/>
            </div>

            {showDisableFeedBtn
                ? <div>
                    Выключить фоновый фид
                    <Checkbox checked={customSettings[CSSettingsItems.disableFeedRequests]}
                              onChange={setSetting.bind(null, CSSettingsItems.disableFeedRequests)}/>
                </div>
                : null
            }

            <div>
                Использовать хоткеи для отправки сообщений
                <Checkbox checked={customSettings[CSSettingsItems.useHotkeys]}
                          onChange={setSetting.bind(null, CSSettingsItems.useHotkeys)}/>
            </div>

            <div>
                Показывать имя пользователя в сообщениях
                <Checkbox checked={customSettings[CSSettingsItems.showUserNameInMessages]}
                          onChange={setSetting.bind(null, CSSettingsItems.showUserNameInMessages)}/>
            </div>
        </div>
        <div className={style.customSettings}>
            <h5>Общее</h5>
            <div>
                <span>Ночная тема <sup>beta</sup></span>
                <Checkbox checked={customSettings[CSSettingsItems.nightMode]}
                          onChange={setSetting.bind(null, CSSettingsItems.nightMode)}/>
            </div>
            <div>
                <span>Сохранять фильтры авто для карты</span>
                <Checkbox checked={customSettings[CSSettingsItems.allowSaveCarsFilters]}
                          onChange={setSetting.bind(null, CSSettingsItems.allowSaveCarsFilters)}/>
            </div>

        </div>
    </div>;
});

export default UserSettings;
