import React, { useState } from 'react';

import { ENVIRONMENT, LSSettingItems } from '../../../../types';
import { Button, ButtonTypes } from '../../../ui/Button';
import { Input } from '../../../ui/Input';
import LS from '../../../utils/localStorage/localStorage';
import * as style from './index.css';
import { UserExtraAccounts } from './UserExtraAccounts';
import UserSettings from './UserSettings';

const Saas = React.memo(() => {
    const ls = new LS();
    const custom = ls.get(LSSettingItems.custom_env);
    const [value, setValue] = useState(custom);
    useState(custom);
    const onchange = (value) => {
        setValue(value);
    };

    const set = () => {
        ls.set(LSSettingItems.custom_env, value);
    };

    const setForce = () => {
        ls.set(LSSettingItems.custom_env, value);
        ls.set(LSSettingItems.env, ENVIRONMENT.CUSTOM);
        location.reload();
    };

    return <>
        <div className={style.saas}>
            <h4>Настройки кастома</h4>
            <Input value={value} onChange={onchange} placeholder={'урл до кастома'}/>
            <Button colorType={ButtonTypes.positive} onClick={set}>Установить значение</Button>
            <Button colorType={ButtonTypes.negative}
                    basic
                    onClick={setForce}>Установить и переключиться на кастом</Button>
        </div>
        <h4>Пользовательские настройки</h4>
        <UserSettings/>
        <UserExtraAccounts/>
    </>;
});

export default Saas;
