import { controlType } from '../../../FormConstructor/types';

export const ADD_STATUS_SCHEMA = {
    state_id: {
        type: controlType.string,
        display: 'state_id',
        order: 1,
    },
    state_description: {
        type: controlType.string,
        display: 'state_description',
        order: 2,
    },
    state_priority: {
        type: controlType.numeric,
        display: 'state_priority',
        order: 3,
    },
    conditions: {
        type: controlType.text,
        display: 'conditions',
        order: 4,
    },
    sensor_filter: {
        type: controlType.structure,
        display: 'sensor_filter',
        order: 5,
        structure: {
            conditions: {
                type: controlType.array_types,
                display: 'conditions',
                order: 1,
                array_type: {
                    timestamp_age: {
                        type: controlType.string,
                        display: 'timestamp_age',
                        order: 0,
                        default: '[null,null]',
                    },
                    sensor: {
                        type: controlType.string,
                        display: 'sensor',
                        order: 0,
                    },
                    value_range: {
                        type: controlType.string,
                        display: 'value_range',
                        order: 0,
                        default: '[null,null]',
                    },
                    since_age: {
                        type: controlType.string,
                        display: 'since_age',
                        order: 0,
                        default: '[null,null]',
                    },
                },
            },
        },
    },
};
