import * as React from 'react';

import { Confirm } from '../../../../ui/FullModal';
import { Request2 } from '../../../../utils/request';
import { REQUESTS, SETTINGS_REQUESTS } from '../../request';
import { IStatusFilter } from '../component';

interface IRemoveStatusModalProps {
    onClose: () => void;
    statusToEdit: IStatusFilter;
    reloadData?: () => void;
}

interface IRemoveStatusModalState {
    error: Error | null;
    isLoading: boolean;
}

export class RemoveStatusModal extends React.Component<IRemoveStatusModalProps, IRemoveStatusModalState> {
    state: IRemoveStatusModalState = {
        error: null,
        isLoading: false,
    };

    request = new Request2({ requestConfigs: SETTINGS_REQUESTS });

    sendData() {
        const { onClose, reloadData, statusToEdit } = this.props;

        this.setState({
            isLoading: true,
        }, () => {
            this.request.exec(REQUESTS.REMOVE_STATUS,{
                body: {
                    ids: [statusToEdit.state_id],
                },
            })
                .then(() => {
                    onClose();
                    if (reloadData) {
                        reloadData();
                    }
                })
                .catch((error) => {
                    this.setState({
                        error,
                        isLoading: false,
                    });
                });
        });
    }

    render() {
        const { error, isLoading } = this.state;
        const { onClose, statusToEdit } = this.props;

        return (
            <Confirm question={`Удалить статус ${statusToEdit.state_description}?`}
                     error={error}
                     accept={this.sendData.bind(this)}
                     isWorking={isLoading}
                     onClose={onClose}/>
        );
    }
}
