import * as React from 'react';

import { EMPTY_DATA } from '../../../../constants';
import { Link } from '../../../../ui/Link';
import { IPlaneTreeItem } from '../../../../ui/VirtualTreeList';
import { Copy } from '../../../Copy';
import { ITag } from '../../../TagModal/component';
import { DEFAULT_LOCATION, DEPRECATED } from '../constants';
import * as style from './index.css';

interface ITagListItemProps {
    item: IPlaneTreeItem<ITag>;
    showPropositions: boolean;
    propositions: Record<string, any>[];
}

export const TagListItem = React.memo((props: ITagListItemProps) => {
    const { item, showPropositions, propositions } = props;
    const { data, meta } = item;
    const { name = EMPTY_DATA, display_name = EMPTY_DATA, comment = EMPTY_DATA, default_priority = EMPTY_DATA } = data;
    const { isTag, childrenCount, filteredChildrenCount } = meta;
    const href = `#${DEFAULT_LOCATION}${encodeURIComponent(name)}`;
    const index = showPropositions
        ? propositions?.filter((el) => el.name === name)
            ?.findIndex((el) => el.proposition_id === data.proposition_id)
        : -1;

    return <div className={`${style.tree_node} ${isTag ? style.tag_item : style.tag_type}`}>
        <div className={style.tag_name} title={name}>
            {isTag
                ? <>
                    <Link href={`${href}${showPropositions ? `/${index}` : ''}`}>
                        {name}
                    </Link>
                    {data?.propositions?.length
                        ? <Link className={style.propositions}
                                href={`${href}/0`}>Предложения: {data.propositions.length}</Link>
                        : null}
                    {showPropositions
                        ? <Copy text={`${location.origin}${location.pathname}${href}/${index}`}
                                className={style.propositions}>
                            Копировать ссылку
                        </Copy>
                        : null}
                </>
                : <div className={`${style.tag_type_title} ${name === DEPRECATED ? style.deprecated : ''}`}>
                    {name}
                    <div className={style.count}>
                        {filteredChildrenCount
                            ? filteredChildrenCount || null
                            : childrenCount || null}
                    </div>
                </div>}
        </div>
        {isTag
            ? <>
                <div className={style.tag_display_name} title={display_name}>
                    {display_name}
                </div>
                <div className={style.tag_priority}>
                    Priority: {default_priority}
                </div>
                <div className={style.tag_comment} title={comment}>
                    {comment}
                </div>
            </>
            : null}
    </div>;
});
