import * as React from 'react';

import { Confirm } from '../../../ui/FullModal';
import { Request2 } from '../../../utils/request';
import { REQUESTS, SETTINGS_REQUESTS } from '../request';

interface IAccountAddModalProps {
    accountName: string;
    onClose: (accountId?: string) => void;
    reloadData?: () => void;
    getNewAccount?: (accountId: number) => Promise<void>;
}

interface IAccountAddModalState {
    isWorking: boolean;
    error: Error | null;
}

export class AccountAddModal extends React.Component<IAccountAddModalProps, IAccountAddModalState> {
    state: IAccountAddModalState = {
        isWorking: false,
        error: null,
    };

    request = new Request2({ requestConfigs: SETTINGS_REQUESTS });

    addNewAccount() {
        const { accountName, getNewAccount, reloadData, onClose } = this.props;
        this.setState({
            isWorking: true,
        }, () => {
            this.request.exec(REQUESTS.CREATE_ACCOUNT, {
                body: {
                    name: accountName,
                },
            })
                .then(async (response) => {
                    reloadData && reloadData();
                    getNewAccount && await getNewAccount(response.account_id);
                    onClose(response.account_id);
                })
                .catch((error) => {
                    this.setState({
                        isWorking: false,
                        error,
                    });
                });
        });
    }

    render() {
        const { accountName, onClose } = this.props;
        const { isWorking, error } = this.state;

        return (
            <Confirm onClose={onClose.bind(this)}
                     question={`Создать экземпляр кошелька ${accountName}?`}
                     isWorking={isWorking}
                     error={error}
                     accept={this.addNewAccount.bind(this)}/>
        );
    }
}
