import * as React from 'react';

import { Confirm } from '../../../ui/FullModal';
import { Request2 } from '../../../utils/request';
import { REQUESTS, SETTINGS_REQUESTS } from '../request';
import style from './index.css';

interface IAccountRemoveModalProps {
    accountId: string;
    onClose: () => void;
    reloadData: () => void;
}

interface IAccountRemoveModalState {
    isWorking: boolean;
    error: Error | null;
}

export class AccountRemoveModal extends React.Component<IAccountRemoveModalProps, IAccountRemoveModalState> {
    state: IAccountRemoveModalState = {
        isWorking: false,
        error: null,
    };

    request = new Request2({ requestConfigs: SETTINGS_REQUESTS });

    removeAccount() {
        const { accountId, onClose, reloadData } = this.props;
        this.setState({
            isWorking: true,
        }, () => {
            this.request.exec(REQUESTS.REMOVE_ACCOUNT, { body: { account_id: accountId } })
                .then(() => {
                    reloadData.call(null);
                    onClose();
                })
                .catch((error) => {
                    this.setState({
                        isWorking: false,
                        error,
                    });
                });
        });
    }

    render() {
        const { accountId, onClose } = this.props;
        const { isWorking, error } = this.state;

        const question = <div>
            <div className={style.delete_warn}>
                <div>Удалять кошелёк можно в супер крайнем случае.</div>
                <div>Поездок по нему быть не должно. Подключенных сотрудников тоже</div>
            </div>
            <div>Удалить кошелёк {accountId ?? ''}?</div>
        </div>;

        return (
            <Confirm onClose={onClose.bind(this)}
                     question={question}
                     isWorking={isWorking}
                     error={error}
                     accept={() => this.removeAccount()}/>
        );
    }
}
