import UserInfo from '../../../models/user';

export enum AccountType {
    BONUS = 'bonus',
    CARD = 'card',
    WALLET = 'wallet',
    YAMONEY = 'yamoney',
    SIMPLE = 'simple'
}

export enum AccountDataType {
    BONUS = 'bonus',
    CARD = 'card',
    SALARY = 'salary',
    SIMPLE = 'simple'
}
export enum PaymentStatus {
    CLEARED = 'cleared',

    CANCELED = 'canceled',
    NOT_AUTHORIZED = 'not_authorized',
}

type AccountDetailsWallet = {
    expenditure: number;
    next_refresh: number;
}

type AccountDetailsCard = {
    card_mask: string;
    paymethod_id: string;
}

type AccountDetailsBonus = {
    balance: number;
    limited_balance?: { deadline?: number; source: string; sum: number }[];
}

type AccountDetails = AccountDetailsCard | AccountDetailsWallet | AccountDetailsBonus | any;

export interface IAccount {
    hard_limit: number;
    soft_limit: number;
    name: string;
    type: AccountType;
    id: number;
    details: AccountDetails;
    comment: string;
    is_active: boolean;
    type_name: string;
    data_type: AccountDataType;
    balance: number;
    spent: number;
    is_actual: boolean;
    parent?: {
        id: number;
        is_active: boolean;
        type_id: number;
        balance: number;
        details?: {
            balance_info?: {
                overdraft: number;
            };
        };
    };
}

export interface IYandexAccount {
    account: string;
    aliases: [];
    balance: number;
    binding_ts: number;
    card_bank: '';
    card_level: '';
    id: string;
    payment_method: 'yandex_account';
    system: '';
    expired?: boolean;
    user?: UserInfo;
}

export interface IAccountDetails {
    data: IAccount;
    users: IAccountUser[];
}

export interface IAccountUser {
    id: string;
    info: string;
}

export interface IWalletType {
    hard_limit: number;
    soft_limit: number;
    name: string;
    type: AccountType;
    meta: {
        hr_name: string;
        refresh_interval: number;
        refresh_policy: string;
        parent_id?: number;
        is_personal?: boolean;
    };
}

export interface ITrustCard {
    payment_method: string;
    binding_ts?: number;
    account: string;
    id: string;
    aliases: string[];
    card_bank?: string;
    card_level?: CardLevels | string;
    system?: PaymentSystem;
    expired?: boolean;
    user?: UserInfo;
    is_family_card_owner?: boolean;
    payer_info?: {
        uid: string;
        family_info: {
            expenses: number;
            limit: number;
            family_id: string;
            currency: string;
            frame: string;
        };
    };
}

export enum PaymentSystem {
    VISA = 'visa',
    MASTERCARD = 'mastercard',
    YANDEX_ACCOUNT = 'yandex_account',
    MOBILE = 'mobile_payment'
}

export enum CardLevels {
    GOLD = 'gold',
    WORLD = 'world',
    WORLD_BLACK = 'black',
    INFINITE = 'infinite',
    SIGNATURE = 'signature',
    PLATINUM = 'platinum',
    WORLD_ELITE = 'elite',
}

export enum FRAME_TRANSLATE {
    "month" = 'в месяц',
    "day" = 'в день',
    "total" = 'всего',
    "week" = 'в неделю'
}

export const REFUND_TAG = 'refund_tag';
export const DEFAULT_TAG_REFUND = 'refund_forgot_finish';
export const SCROOGEMCDUCK = 'ScroogeMcDuck';
export const ROBOT = 'billing_robot';

export interface IAccountHistoryItem {
    'operations_history': {
        'action': string;
        'type_id': string;
        'active': boolean;
        'timestamp': number;
        'account_id': string;
        'created_at': string;
        'spent': string;
        'user_id': string;
        'account_meta': string;
        'version': number;
    }[];
    'links_history': {
        'history_user_id': string;
        'history_timestamp': number;
        'history_action': string;
        'user_id': string;
        'account_id': string;
    }[];
}
