import { getActuality } from '../../constants';
import { combineRequests, IComponentRequest, REQUEST_METHOD } from '../../utils/request';
import { MIGRATE_REQUESTS, REQUESTS as REQUESTS_CONFIG } from '../Migrate/request';

export const GVARS_INTERFACE_ATTRIBUTES_PREFIX = 'administration.attributes';

export const REQUESTS: { [key: string]: string } = combineRequests(
    {
        GET_ROLES: 'GET_ROLES',
        DELETE_ROLE: 'DELETE_ROLE',
        GET_ACTIONS: 'GET_ACTIONS',
        GET_EXTERNAL_PROMO: 'GET_EXTERNAL_PROMO',
        UPLAOD_EXTERNAL_PROMO: 'UPLAOD_EXTERNAL_PROMO',
        ROLES_SNAPSHOT_UPSERT: 'ROLES_SNAPSHOT_UPSERT',
        ROLES_SNAPSHOT_PROPOSE: 'ROLES_SNAPSHOT_PROPOSE',
        ROLES_SNAPSHOT_REJECT: 'ROLES_SNAPSHOT_REJECT',
        ROLES_SNAPSHOT_CONFIRM: 'ROLES_SNAPSHOT_CONFIRM',
        AREAS_INFO: 'AREAS_INFO',
        AREAS_HISTORY: 'AREAS_HISTORY',
        AREA_TAG_HISTORY: 'AREA_TAG_HISTORY',
        AREA_TAG_REMOVE: 'AREA_TAG_REMOVE',

        AREA_UPSERT: 'AREA_UPSERT',
        AREA_PROPOSE: 'AREA_PROPOSE',
        AREA_CONFIRM: 'AREA_CONFIRM',
        AREA_REJECT: 'AREA_REJECT',
        AREA_REMOVE: 'AREA_REMOVE',
        AREA_HISTORY: 'AREA_HISTORY',

        ACTION_CONFIRM: 'ACTION_CONFORM',
        ACTION_REJECT: 'ACTION_REJECT',

        LANDING_CONFIRM: 'LANDING_CONFIRM',
        LANDING_REJECT: 'LANDING_REJECT',

        GET_WALLETS_DESCRIPTIONS: 'GET_WALLETS_DESCRIPTIONS',
        GET_WALLET: 'GET_WALLET',
        CREATE_ACCOUNT: 'CREATE_ACCOUNT',
        REMOVE_ACCOUNT: 'REMOVE_ACCOUNT',
        ACTIVATE_ACCOUNT: 'ACTIVATE_ACCOUNT',
        UPDATE_WALLET: 'UPDATE_WALLET',
        UPDATE_ACCOUNT: 'UPDATE_ACCOUNT',
        GET_ACCOUNT_HISTORY: 'GET_ACCOUNT_HISTORY',

        GET_PROMO: 'GET_PROMO',
        GENERATE_PROMO: 'GENERATE_PROMO',
        GIVE_OUT_PROMO: 'GIVE_OUT_PROMO',
        GET_TAGS: 'GET_TAGS',
        CREATE_TAG: 'CREATE_TAG',
        DELETE_TAG: 'DELETE_TAG',
        TAG_PROPOSE: 'TAG_PROPOSE',
        TAG_CONFIRM: 'TAG_CONFIRM',
        TAG_REJECT: 'TAG_REJECT',

        GET_STATE_FILTERS: 'GET_STATE_FILTERS',
        REMOVE_STATUS: 'REMOVE_STATUS',
        UPSERT_STATUS: 'UPSERT_STATUS',

        GET_ML_MODELS: 'GET_ML_MODELS',
        GET_ML_MODEL: 'GET_ML_MODEL',
        SEND_ML_MODEL: 'SEND_ML_MODEL',
        REMOVE_ML_MODEL: 'REMOVE_ML_MODEL',

        CHECK_USER: 'CHECK_USER',
        EDIT_USER: 'EDIT_USER',

        ADD_MDS_RESOURCES: 'ADD_MDS_RESOURCES',
        GET_MDS_RESOURCES: 'GET_MDS_RESOURCES',
        REMOVE_MDS_RESOURCES: 'REMOVE_MDS_RESOURCES',
        GET_USERS_BY_ROLE: 'GET_USERS_BY_ROLE',
        ACTIVATE_ROLE_USERS: 'ACTIVATE_ROLE_USERS',
        DEACTIVATE_ROLE_USERS: 'DEACTIVATE_ROLE_USERS',
        DELETE_MANAGE_ROLES: 'DELETE_MANAGE_ROLES',
        ADD_MANAGE_ROLES: 'ADD_MANAGE_ROLES',

        GET_ATTRIBUTES: 'GET_ATTRIBUTES',

        SEARCH: 'SEARCH',
        GET_GVARS: 'GET_GVARS',

        GET_NOTIFIERS: 'GET_NOTIFIERS',
        UPSERT_NOTIFIERS: 'UPSERT_NOTIFIERS',
        UPSERT_LANDING: 'UPSERT_LANDING',

    }, REQUESTS_CONFIG);

const bucket = 'carsharing';

export const SETTINGS_REQUESTS: IComponentRequest = combineRequests({
    [REQUESTS.GET_ROLES]: {
        api: 'roles/list',
        cgiObj: {
            report: null,
        },
    },
    [REQUESTS.DELETE_ROLE]: {
        method: REQUEST_METHOD.POST,
        api: 'roles/remove',
        cgiObj: {
            roles: null,
        },
    },
    [REQUESTS.GET_ATTRIBUTES]: {
        api: 'settings/info',
        cgiObj: {
            prefix: GVARS_INTERFACE_ATTRIBUTES_PREFIX,
            actuality: getActuality(),
        },
    },
    [REQUESTS.ROLES_SNAPSHOT_UPSERT]: {
        method: REQUEST_METHOD.POST,
        api: 'roles/snapshot/upsert',
    },
    [REQUESTS.ROLES_SNAPSHOT_PROPOSE]: {
        method: REQUEST_METHOD.POST,
        api: 'roles/snapshot/propose',
        cgiObj: {
            comment: null,
        },
    },
    [REQUESTS.ROLES_SNAPSHOT_REJECT]: {
        method: REQUEST_METHOD.POST,
        api: 'roles/snapshot/reject',
    },
    [REQUESTS.ROLES_SNAPSHOT_CONFIRM]: {
        method: REQUEST_METHOD.POST,
        api: 'roles/snapshot/confirm',
    },
    [REQUESTS.GET_ACTIONS]: {
        api: 'actions/list',
    },
    [REQUESTS.GET_EXTERNAL_PROMO]: {
        api: 'external_promo/info',
    },
    [REQUESTS.UPLAOD_EXTERNAL_PROMO]: {
        method: REQUEST_METHOD.POST,
        api: 'external_promo/upload',
    },

    [REQUESTS.ACTION_CONFIRM]: {
        method: REQUEST_METHOD.POST,
        api: 'actions/confirm',
    },

    [REQUESTS.ACTION_REJECT]: {
        method: REQUEST_METHOD.POST,
        api: 'actions/reject',
    },

    [REQUESTS.LANDING_CONFIRM]: {
        method: REQUEST_METHOD.POST,
        api: 'landing/confirm',
        cgiObj: {
            comment: 'confirm',
        },
    },

    [REQUESTS.LANDING_REJECT]: {
        method: REQUEST_METHOD.POST,
        api: 'landing/reject',
        cgiObj: {
            comment: 'reject',
        },
    },

    [REQUESTS.AREAS_INFO]: {
        api: 'areas/info',
    },
    [REQUESTS.AREAS_HISTORY]: {
        api: 'areas/history',
    },
    [REQUESTS.AREA_TAG_HISTORY]: {
        api: 'area_tags/history',
        cgiObj: {
            object_id: null,
        },
    },
    [REQUESTS.AREA_TAG_REMOVE]: {
        api: 'area_tags/remove',
        cgiObj: {
            tag_id: null,
        },
    },
    [REQUESTS.AREA_UPSERT]: {
        method: REQUEST_METHOD.POST,
        api: 'areas/upsert',
    },

    [REQUESTS.AREA_REMOVE]: {
        method: REQUEST_METHOD.POST,
        api: 'areas/remove',
    },

    [REQUESTS.AREA_HISTORY]: {
        api: 'areas/history',
    },

    [REQUESTS.AREA_PROPOSE]: {
        method: REQUEST_METHOD.POST,
        api: 'areas/propositions/propose',
        cgiObj: {
            comment: null,
        },
    },

    [REQUESTS.AREA_REJECT]: {
        method: REQUEST_METHOD.POST,
        api: 'areas/propositions/reject',
        cgiObj: {
            comment: null,
        },
    },
    [REQUESTS.AREA_CONFIRM]: {
        method: REQUEST_METHOD.POST,
        api: 'areas/propositions/confirm',
        cgiObj: {
            comment: null,
        },
    },
    [REQUESTS.GET_WALLETS_DESCRIPTIONS]: {
        api: 'billing/accounts/descriptions',
        cgiObj: {
            account_name: null,
        },
    },
    [REQUESTS.GET_WALLET]: {
        api: 'billing/accounts',
        cgiObj: {
            account_id: null,
            account_name: null,
            numdoc: null,
            from: null,
        },
    },
    [REQUESTS.CREATE_ACCOUNT]: {
        method: REQUEST_METHOD.POST,
        api: 'billing/accounts/create',
    },
    [REQUESTS.REMOVE_ACCOUNT]: {
        method: REQUEST_METHOD.POST,
        api: 'billing/accounts/remove',
    },
    [REQUESTS.ACTIVATE_ACCOUNT]: {
        method: REQUEST_METHOD.POST,
        api: 'billing/accounts/activate',
    },
    [REQUESTS.UPDATE_WALLET]: {
        method: REQUEST_METHOD.POST,
        api: 'billing/accounts/update',
    },
    [REQUESTS.UPDATE_ACCOUNT]: {
        method: REQUEST_METHOD.POST,
        api: 'billing/accounts/update_data',
    },
    [REQUESTS.GET_ACCOUNT_HISTORY]: {
        api: 'billing/accounts/history',
        cgiObj: {
            account_id: null,
        },
    },

    [REQUESTS.GET_PROMO]: {
        api: 'promo/get',
        cgiObj: {
            active_only: null,
            since: null,
            until: null,
            prefix: null,
            count: null,
            given_out: null,
            generator: null,
        },
    },
    [REQUESTS.GENERATE_PROMO]: {
        method: REQUEST_METHOD.POST,
        api: 'promo/generation',
        cgiObj: {
            count: null,
            generator: null,
            scheme: null,
        },
    },
    [REQUESTS.GIVE_OUT_PROMO]: {
        method: REQUEST_METHOD.POST,
        api: 'promo/give_out',
    },
    [REQUESTS.GET_TAGS]: {
        api: 'tag/description/list',
    },
    [REQUESTS.CREATE_TAG]: {
        method: REQUEST_METHOD.POST,
        api: 'tag/description/add',
    },
    [REQUESTS.DELETE_TAG]: {
        api: 'tag/description/remove',
        cgiObj: {
            tag_name: null,
            real_remove: null,
        },
    },
    [REQUESTS.TAG_PROPOSE]: {
        method: REQUEST_METHOD.POST,
        api: 'tag/description/propose',
        cgiObj: {
            comment: null,
        },
    },
    [REQUESTS.TAG_CONFIRM]: {
        method: REQUEST_METHOD.POST,
        api: 'tag/description/confirm',
        cgiObj: {
            comment: null,
        },
    },
    [REQUESTS.TAG_REJECT]: {
        method: REQUEST_METHOD.POST,
        api: 'tag/description/reject',
        cgiObj: {
            comment: null,
        },
    },
    [REQUESTS.GET_STATE_FILTERS]: {
        api: 'state_filters/info',
    },
    [REQUESTS.REMOVE_STATUS]: {
        method: REQUEST_METHOD.POST,
        api: 'state_filters/remove',
    },
    [REQUESTS.UPSERT_STATUS]: {
        method: REQUEST_METHOD.POST,
        api: 'state_filters/upsert',
    },
    [REQUESTS.GET_ML_MODELS]: {
        api: 'ranking/model/list',
    },
    [REQUESTS.GET_ML_MODEL]: {
        api: 'ranking/model/get',
        cgiObj: {
            name: null,
        },
    },
    [REQUESTS.SEND_ML_MODEL]: {
        method: REQUEST_METHOD.POST,
        api: 'ranking/model/add',
        cgiObj: {
            meta: null,
            separator: null,
        },
    },
    [REQUESTS.REMOVE_ML_MODEL]: {
        method: REQUEST_METHOD.POST,
        api: 'ranking/model/remove',
    },
    [REQUESTS.CHECK_USER]: {
        api: 'user/report',
        cgiObj: {
            user_id: null,
        },
    },
    [REQUESTS.EDIT_USER]: {
        api: 'user/edit',
        method: REQUEST_METHOD.POST,
    },
    [REQUESTS.ADD_MDS_RESOURCES]: {
        method: REQUEST_METHOD.POST,
        api: `mds/add`,
        cgiObj: {
            key: null,
            bucket: bucket,
        },
    },
    [REQUESTS.GET_MDS_RESOURCES]: {
        api: 'mds/info',
        cgiObj: {
            bucket: bucket,
            report: 'objects',
        },
    },

    [REQUESTS.REMOVE_MDS_RESOURCES]: {
        api: 'mds/remove',
        method: REQUEST_METHOD.POST,
        cgiObj: {
            bucket: bucket,
            key: null,
        },
    },
    [REQUESTS.GET_USERS_BY_ROLE]: {
        api: 'roles/users',
        cgiObj: {
            roles: null,
            page: null,
            page_size: null,
        },
    },
    [REQUESTS.ACTIVATE_ROLE_USERS]: {
        api: 'user/roles/activate',
        cgiObj: {
            role_id: null,
            user_id: null,
        },
    },
    [REQUESTS.DEACTIVATE_ROLE_USERS]: {
        api: 'user/roles/deactivate',
        cgiObj: {
            role_id: null,
            user_id: null,
        },
    },
    [REQUESTS.DELETE_MANAGE_ROLES]: {
        api: 'user/roles/remove',
        cgiObj: {
            roles: null,
            user_id: null,
        },
    },
    [REQUESTS.ADD_MANAGE_ROLES]: {
        method: REQUEST_METHOD.POST,
        api: 'user/roles/add',
        cgiObj: {
            user_id: null,
        },
    },
    [REQUESTS.SEARCH]: {
        api: 'search',
        cgiObj: {
            has_all_of: null,
            limit: null,
            what: null,
        },
    },
    [REQUESTS.GET_GVARS]: {
        api: 'settings/info',
        cgiObj: {
            prefix: null,
        },
    },

    [REQUESTS.GET_NOTIFIERS]: {
        api: 'notifiers/info',
        cgiObj: {
            ids: null,
        },
    },
    [REQUESTS.UPSERT_NOTIFIERS]: {
        api: 'notifiers/upsert',
        method: REQUEST_METHOD.POST,
    },
    [REQUESTS.UPSERT_LANDING]: {
        method: REQUEST_METHOD.POST,
        api: 'landing/upsert',
    },

}, MIGRATE_REQUESTS);
