import * as React from 'react';

import * as style from './index.css';

export type ElementsSizeType = 's' | 'x' | 'l' | 'xl';

interface ISpinProps {
    size?: ElementsSizeType;
    className?: string;
}

function Spin(props: ISpinProps) {
    return (
        <div className={`${style.spin} ${style['size_' + props.size]} ${props.className || ''}`}/>
    );
}

export const CenteredSpin = (props: ISpinProps) => {
    return <div className={style.spin_container}>
        <Spin size={props.size}/>
    </div>;
};

export default Spin;
