import { Dict } from '../../../../../types';
import { controlType, ISchemaItem } from '../../../FormConstructor/types';

const period = 24;
const times = new Array(period).fill(1).map((_, index) => {
    return `${index}:00`;
});

export const schema: Dict<ISchemaItem> = {
    'incidents': {
        'type': controlType.text,
        'display_name': '🚨 Инциденты и ДТП',
        'order': 0,
    },
    'bugs': {
        'type': controlType.text,
        'display_name': '🗓 Баг-репорты/Новые таски',
        'order': 0,
    },
    'service': {
        'type': controlType.text,
        'display_name': '⚙️ Сервисное приложение',
        'order': 0,
    },
    'feedback': {
        'type': controlType.text,
        'display_name': '❌ Фидбек клиентов',
        'order': 0,
    },
    'top_5': {
        'type': controlType.text,
        'display_name': '✍️ Топ-5 запросов',
        'order': 0,
    },
    'for_next': {
        'type': controlType.text,
        'display_name': '➡️ Для сменщика',
        'order': 0,
    },
    since: {
        type: controlType.variants,
        'display_name': 'Начало периода',
        variants: times,
    },
    until: {
        type: controlType.variants,
        'display_name': 'Конец периода',
        variants: times,
    },

};
