import { Dict } from '../../../../../types';
import { controlType, ISchemaItem } from '../../../FormConstructor/types';

const period = 24;
const times = new Array(period).fill(1).map((_, index) => {
    return `${index}:00`;
});

export const schema: Dict<ISchemaItem> = {
    'incidents': {
        'type': controlType.text,
        'display_name': '🚔 Тяжелые/значимые инциденты',
        'order': 0,
    },
    'bugs': {
        'type': controlType.text,
        'display_name': '🆘 Факапы',
        'order': 0,
    },
    'reports': {
        'type': controlType.text,
        'display_name': '⚙️ Баг-репорты/новые таски',
        'order': 0,
    },
    'top_5': {
        'type': controlType.text,
        'display_name': '✍️ Топ-5 запросов',
        'order': 0,
    },
    'fun': {
        'type': controlType.text,
        'display_name': '🙂 Интересное/смешное',
        'order': 0,
    },
    'loyalty': {
        'type': controlType.text,
        'display_name': '🥰 Лояльность (такси/еда)',
        'order': 0,
    },
    'dev': {
        'type': controlType.text,
        'display_name': '💻 Сборка',
        'order': 0,
    },
    'extra': {
        'type': controlType.text,
        'display_name': '⭐️ Дополнительный час',
        'order': 0,
    },
    'current': {
        'type': controlType.text,
        'display_name': '🗓 Текущие задачи',
        'order': 0,
    },
    custom: {
        'type': controlType.text,
        'display_name': 'Прочее',
        'order': 0,
    },
    since: {
        type: controlType.variants,
        'display_name': 'Начало периода',
        variants: times,
    },
    until: {
        type: controlType.variants,
        'display_name': 'Конец периода',
        variants: times,
    },

};
