import React from 'react';

import { Dict } from '../../../../types';
import { Button } from '../../../ui/Button';
import { Copy } from '../../Copy';
import { FormConstructor } from '../../FormConstructor';
import { ISchemaItem } from '../../FormConstructor/types';
import { copyReport } from './const';
import style from './index.css';

interface IReportProps {
    schema: Dict<ISchemaItem>;
    reportType: any;
}

export const Report = (props: IReportProps) => {
    const [data, setData] = React.useState({});
    const [copyText, copy] = React.useState('');

    React.useEffect(() => {
        if (Object.entries(data).length) {
            copy(copyReport.bind(null, props.reportType, data, props.schema));
        } else {
            copy('');
        }
    }, [data]);

    return <div>
        <h1>Отчёт</h1>
        <div>Помни, что каждый новый пункт должен начинаться с новой строки и знака</div>
        <FormConstructor schema={props.schema} className={style.report} onChange={setData.bind(null)}/>
        <div className={style.buttons}>
            {
                Object.entries(data).length ? <Copy text={copyText} className={style.copy}>
                    <Button>Скопировать</Button>
                </Copy> : <Button disabled>Скопировать</Button>
            }
        </div>
    </div>;
};
