import React from 'react';

import { Button } from '../../../ui/Button';
import TextArea from '../../../ui/TextArea';
import { Request2 } from '../../../utils/request';
import { SimpleError } from '../../SimpleError';
import { REQUESTS, SUPPORT_REQUESTS as requestConfigs } from '../request';
import * as style from './index.css';

export default class Devices extends React.Component {
    state = {
        value: '',
        result: '',
        isLoading: false,
        response: [],
        err: null,
    };

    request = new Request2({
        requestConfigs,
    });

    onChange(key, value) {
        this.setState({ [key]: value });
    }

    formatResult(data: any[]) {
        return data && data.length ? data.reduce((_p, _c) => {
            _p += `userId: ${_c.devices[0].user_id}\n`;
            _c.devices.forEach(el => {
                _p += `\t device_id: ${el.device_id}\n`;
                _p += `\t\t UUID: ${el.description.headers.UUID}\n`;
                _p += `\t\t UA: ${el.description.headers['User-Agent']}\n`;
            });
            _p += '\n';

            return _p;
        }, '') : 'нет данных';
    }

    getDevices() {
        const ids = this.state.value.split('\n').filter(el => el).map(el => el.trim());
        this.setState({
            isLoading: true,
        }, () => {
            Promise.all(ids.map(el => this.request.exec(REQUESTS.GET_DEVICES, {
                queryParams: {
                    user_id: el,
                },
            })))
                .then(response => {

                    this.setState({
                        response,
                        isLoading: false,
                        result: this.formatResult(response),
                        err: null,
                    });
                })
                .catch((err) => {
                    this.setState({
                        response: [],
                        isLoading: false,
                        err,
                    });
                });
        });
    }

    render() {
        return <div>
            {
                this.state.err && <SimpleError error={this.state.err}/>
            }
            <TextArea value={this.state.value}
                      placeholder={'укажите ID пользователей'}
                      onChange={this.onChange.bind(this, 'value')}
                      disabled={this.state.isLoading}
                      className={style.textarea}/>
            <Button className={style.btn}
                    isLoading={this.state.isLoading}
                    onClick={this.getDevices.bind(this)}>Получить информацию</Button>
            <TextArea value={this.state.result}
                      placeholder={'информация по устройствам'}
                      onChange={this.onChange.bind(this, 'result')}
                      className={`${style.textarea} ${style.result}`}/>
        </div>;
    }
}
