import React from 'react';

import { IFormPreviewProps } from '../childComponents/FormPreview';
import style from '../index.css';

type IFeatureTemplateProps = IFormPreviewProps

export const FeatureTemplate = React.memo((props: IFeatureTemplateProps) => {
    const { item } = props;

    const objectPosition = item.image_style === 'rounded'
        ? 'center'
        : item.image_style;

    const imageMargin = item.image_style === 'top'
        ? { top: '25px' }
        : item.image_style === 'bottom'
            ? { bottom: '25px' }
            : item.image_style === 'rounded'
                ? { width: '147px', height: '147px', borderRadius: '12px' }
                : {};

    const containerStyle = item.image_style === 'rounded'
        ? { display: 'flex', alignSelf: 'center' }
        : {};

    return <div className={style.feature_template} style={{}}>
        <div className={style.info}>
            <div className={style.title}>{item.title ?? ''}</div>
            <div className={style.subtitle}>{item.subtitle ?? ''}</div>
        </div>

        <div className={style.picture} style={{ ...containerStyle }}>
            <img src={item.image}
                 alt=""
                 className={style.img}
                 style={{ objectPosition: objectPosition, ...imageMargin }}/>
        </div>
    </div>;
});
