import React from 'react';

import { IFormPreviewProps } from '../childComponents/FormPreview';
import style from '../index.css';

type IModelTemplateProps = IFormPreviewProps

export const ModelTemplate = React.memo((props: IModelTemplateProps) => {
    const { item } = props;

    let backgroundStyle;

    if (item.bg_color_bottom && item.bg_color_top) {
        backgroundStyle = {
            background: `linear-gradient(${item.bg_color_top}, ${item.bg_color_bottom})`,
        };
    } else {
        backgroundStyle = {
            backgroundColor: `${item.bg_color_top ?? 'fff'}`,
        };
    }

    return <div className={style.model_template} style={...backgroundStyle}>
        <img src={item.icon} className={style.icon} alt=""/>

        <div className={style.title} style={{ color: item.title_color ?? '#000' }}>
            {item.name}
        </div>
    </div>;
});
