import React from 'react';

import { IFormPreviewProps } from '../childComponents/FormPreview';
import style from '../index.css';

type IOfferTemplateProps = IFormPreviewProps

export const OfferTemplate = React.memo((props: IOfferTemplateProps) => {
    const { item } = props;
    const titleColor = item.color ?? '#000';

    return <div className={style.offer_template}>
        <div className={style.title} style={{ color: titleColor }}>
            {item.name}
        </div>

        <hr style={{ border: `1px solid ${titleColor}` }}/>

        <div className={style.price}>
            {item.price ?
                <>
                    {item.price.prefix ?? ''} &nbsp;
                    <span className={style.price_num}>
                        <b>{item.price.price ?? ''}</b>
                    </span> &nbsp;
                    {item.price.suffix ?? ''}
                </>
                : item.price_string
                    ? item.price_string
                    : null
            }
        </div>

        <div className={style.details}>
            <ul>
                {item.details?.map((detail, ind) => {
                    return <li key={detail + ind}>{detail}</li>;
                })}
            </ul>
        </div>
    </div>;
});
