import React, { useEffect, useState } from 'react';

import { useRequestHandler } from '../../../../hooks/useRequestHandler';
import { Confirm } from '../../../../ui/FullModal';
import { Request2 } from '../../../../utils/request';
import { deepCopy } from '../../../../utils/utils';
import { REQUESTS, SUPPORT_REQUESTS } from '../../request';
import { GVARS_PREFIX } from '../constants';

interface IDeleteElementModalProps {
    onClose: () => void;
    data: any;
    entity: string;
    instance: string;
    updateData: () => void;
}

export const DeleteElementModal = React.memo((props: IDeleteElementModalProps) => {
    const { onClose, data, entity, instance, updateData } = props;

    const [isDeleting, setDeleting] = useState<boolean>(false);

    const request = new Request2({ requestConfigs: SUPPORT_REQUESTS });

    const getDeletingOptions = React.useMemo(() => {
        const gvarCopy = deepCopy(data ?? {});

        delete gvarCopy[entity][instance];

        return {
            requestName: REQUESTS.UPSERT_SETTINGS,
            requestOptions: {
                body: {
                    settings: [
                        {
                            setting_key: GVARS_PREFIX,
                            setting_value: JSON.stringify(gvarCopy),
                        },
                    ],
                },
            },
        };
    }, [isDeleting]);

    const onDelete = () => {
        setDeleting(false);
        updateData();
        onClose();
    };

    const [
        isDeletingLoading, ,
        deletingError,
        deleteElement,
    ] = useRequestHandler<any[]>(request, getDeletingOptions, onDelete.bind(null));

    const deleteItem = () => {
        setDeleting(true);
        deleteElement();
    };

    useEffect(() => {
        return () => request.abort();
    }, []);

    return <Confirm question={'Вы действительно хотите удалить элемент?'}
                    error={deletingError}
                    accept={deleteItem}
                    onClose={onClose}
                    isWorking={isDeletingLoading}/>;
});
