import { Dict } from '../../../../../types';
import { ISchemaItem } from '../../../FormConstructor/types';
import { KNOWN_FIELDS } from '../constants';

export const FormBuilder = (formData): Dict<ISchemaItem> => {
    const fields = Object.keys(formData);
    const schema: Dict<ISchemaItem> = {};

    fields.forEach(field => {
        KNOWN_FIELDS[field]
            ? schema[field] = KNOWN_FIELDS[field]
            : schema[field] = field as ISchemaItem;
    });

    if (schema.bg_color_top) {
        schema.bg_color_bottom = KNOWN_FIELDS.bg_color_bottom;
    }

    return schema;
};
