import React from 'react';

import { FeatureTemplate } from '../PreviewTemplates/FeatureTemplate';
import { ModelTemplate } from '../PreviewTemplates/ModelTemplate';
import { OfferTemplate } from '../PreviewTemplates/OfferTemplate';

export interface IFormPreviewProps {
    entity: string;
    item: any;
}

export const FormPreview = React.memo((props: IFormPreviewProps) => {
    const { entity, item } = props;

    const templates = {
        models: <ModelTemplate {...props}/>,
        offers: <OfferTemplate {...props}/>,
        features: <FeatureTemplate {...props}/>,
    };

    return entity && item
        ? templates[entity]
        : null;
});
