import { controlType, SchemaItemVisual } from '../../FormConstructor/types';

export const availableEntityOptions = ['features', 'models', 'offers', 'cities'];
export const availableToAddOptions = ['features', 'models'];
export const AVAILABLE_CITY_OPTIONS = ['cases', 'cars', 'faq', 'features', 'promo'];
export const INFO_ITEMS = ['models', 'offers', 'features'];
export const GVARS_PREFIX = 'user_app.settings.b2c_web_info';
export const INFO_ITEM_TITLES = {
    models: 'Cars',
    offers: 'Offers',
    features: 'Features',
};

const STANDARD_CITY_FIELDS = {
    name: {
        type: controlType.string,
        required: true,
    },
    icon: {
        type: controlType.string,
        required: true,
    },
    title: {
        type: controlType.string,
        required: true,
    },
    id: {
        type: controlType.string,
        required: true,
    },
    show_in_header: {
        type: controlType.bool,
    },
};

const CAR_STRUCTURE = {
    title: {
        type: controlType.string,
    },
    subtitle: {
        type: controlType.text,
    },
    color: {
        type: controlType.string,
        visual: SchemaItemVisual.COLOR,
    },
    cars: {
        type: controlType.array_types,
        array_type: {
            type: controlType.string,
        },
    },
};

const CASE_STRUCTURE = {
    title: {
        type: controlType.string,
    },
    cars: {
        type: controlType.array_types,
        array_type: {
            type: controlType.string,
        },
    },
    features: {
        type: controlType.array_types,
        array_type: {
            type: controlType.string,
        },
    },
    offers: {
        type: controlType.array_types,
        array_type: {
            type: controlType.string,
        },
    },
};

const FAQ_STRUCTURE = {
    title: {
        type: controlType.string,
    },
    questions: {
        type: controlType.array_types,
        array_type: {
            type: controlType.structure,
            structure: {
                question: {
                    type: controlType.text,
                },
                answer: {
                    type: controlType.text,
                },
            },
        },
    },
};

export const CARS_SCHEME = {
    ...STANDARD_CITY_FIELDS,
    data: {
        type: controlType.array_types,
        array_type: {
            type: controlType.structure,
            structure: {
                ...CAR_STRUCTURE,
            },
        },
    },
};

export const CASES_SCHEME = {
    ...STANDARD_CITY_FIELDS,
    data: {
        type: controlType.array_types,
        array_type: {
            type: controlType.structure,
            structure: {
                ...CASE_STRUCTURE,
            },
        },
    },
};

export const FAQ_SCHEME = {
    ...STANDARD_CITY_FIELDS,
    data: {
        type: controlType.array_types,
        array_type: {
            type: controlType.structure,
            structure: {
                ...FAQ_STRUCTURE,
            },
        },
    },
};

export const FEATURES_SCHEME = {
    ...STANDARD_CITY_FIELDS,
    data: {
        type: controlType.array_types,
        array_type: {
            type: controlType.string,
        },
    },
};

export const PROMO_SCHEME = {
    ...STANDARD_CITY_FIELDS,
    data: {
        type: controlType.structure,
        structure: {
            title: {
                type: controlType.string,
            },
            button_title: {
                type: controlType.string,
            },
            button_subtitle: {
                type: controlType.string,
            },
            features: {
                type: controlType.array_types,
                array_type: {
                    name: {
                        type: controlType.string,
                    },
                    icon: {
                        type: controlType.string,
                    },
                },
            },
        },
    },
};

export const OPTIONS_SCHEMES = {
    cases: CASES_SCHEME,
    cars: CARS_SCHEME,
    faq: FAQ_SCHEME,
    features: FEATURES_SCHEME,
    promo: PROMO_SCHEME,
};

export const KNOWN_FIELDS = {
    name: {
        type: controlType.string,
        required: true,
    },
    color: {
        type: controlType.string,
        visual: SchemaItemVisual.COLOR,
        required: true,
    },
    bg_color_top: {
        type: controlType.string,
        visual: SchemaItemVisual.COLOR,
        required: true,
    },
    bg_color_bottom: {
        type: controlType.string,
        required: false,
    },
    title_color: {
        type: controlType.string,
        visual: SchemaItemVisual.COLOR,
        required: true,
    },
    details: {
        type: controlType.array_types,
        array_type: {
            type: controlType.string,
        },
        required: true,
    },
    price: {
        type: controlType.json,
        required: true,
    },
    price_string: {
        type: controlType.string,
        required: true,
    },
    icon: {
        type: controlType.string,
        required: true,
    },
    image: {
        type: controlType.string,
        required: true,
    },
    image_style: {
        type: controlType.variants,
        editable: true,
        variants: [
            'top',
            'bottom',
            'rounded',
            'center',
        ],
        required: true,
    },
    title: {
        type: controlType.string,
        required: true,
    },
    subtitle: {
        type: controlType.text,
        required: true,
    },
    show_in_header: {
        type: controlType.bool,
    },
};

export const MODEL_STANDARD_SCHEME = {
    name: KNOWN_FIELDS.name,
    bg_color_top: KNOWN_FIELDS.bg_color_top,
    bg_color_bottom: KNOWN_FIELDS.bg_color_bottom,
    title_color: KNOWN_FIELDS.title_color,
    icon: KNOWN_FIELDS.icon,
};

export const FEATURE_STANDARD_SCHEME = {
    title: KNOWN_FIELDS.title,
    subtitle: KNOWN_FIELDS.subtitle,
    title_color: KNOWN_FIELDS.title_color,
    image: KNOWN_FIELDS.image,
    image_style: KNOWN_FIELDS.image_style,
};

export const MODEL_INITIAL = {
    bg_color_top: 'fff',
    bg_color_bottom: null,
    title_color: '000',
};

export const FEATURE_INITIAL = {
    image_style: 'rounded',
};
