import React from 'react';

import { Confirm } from '../../../../ui/FullModal';
import { Link } from '../../../../ui/Link';
import { Request2 } from '../../../../utils/request';
import Spin from '../../../Spin';
import style from './index.css';
import { check_cards, requestConfigs, REQUESTS } from './request';

export class CheckCards extends React.Component<any, any> {
    request = new Request2({ requestConfigs });
    state = {
        isLoading: false,
        isWorking: false,
        error: null,
        actionError: null,
        status: null,
        confirmIsOpen: false,
    };

    getStatus() {
        this.setState({
            isLoading: true,
        }, () => {
            this.request.exec(REQUESTS.GET_STATUS).then(response => {
                this.setState({
                    isLoading: false,
                    status: response?.settings?.[0]?.setting_value,
                });
            })
                .catch(error => {
                    this.setState({
                        error,
                        isLoading: false,
                    });
                });
        });
    }

    componentDidMount() {
        this.getStatus();
    }

    componentWillUnmount() {
        this.request.abort();
    }

    openConfirm(confirmIsOpen) {
        this.setState({
            confirmIsOpen,
        });
    }

    accept() {
        const setting_key = check_cards;
        let setting_value: string;
        if (this.state.status === 'true') {
            setting_value = 'false';
        } else {
            setting_value = 'true';
        }

        this.setState({
            isWorking: true,
        }, () => {
            this.request.exec(REQUESTS.UPSERT_SETTINGS, {
                body: {
                    settings: [{ setting_key, setting_value }],
                },
            }).then(() => {
                this.setState({
                    isWorking: false,
                    confirmIsOpen: false,
                }, () => {
                    this.getStatus();
                });
            }).catch((actionError) => {
                this.setState({ actionError, isWorking: false }, () => {
                    this.getStatus();
                });
            });
        });
    }

    render() {
        const { status, isLoading, confirmIsOpen, isWorking, actionError } = this.state;

        return <div>
            {
                confirmIsOpen
                &&
                <Confirm error={actionError}
                         isWorking={isWorking}
                         onClose={this.openConfirm.bind(this, false)}
                         accept={this.accept.bind(this)}
                         question={`${status === 'true' ? 'Выключить' : 'Включить'}?`}/>
            }

            {isLoading ? <Spin size={'s'}/>
                : <>
                    <span className={`${style.status} ${style[`status_${status}`]}`}/>
                    <Link onClick={this.openConfirm.bind(this, true)}>{status === 'true' ? 'выкл' : 'вкл'}</Link>
                </>}
        </div>;
    }
}
