import { IComponentRequest, REQUEST_METHOD } from '../../../../utils/request';

export const check_cards = `billing.book.check_cards`;

export enum REQUESTS {
    GET_STATUS = 'GET_STATUS',
    UPSERT_SETTINGS = 'UPSERT_SETTINGS'
}

export const requestConfigs: IComponentRequest = {
    [REQUESTS.GET_STATUS]: {
        api: 'settings/info',
        cgiObj: {
            prefix: check_cards,
        },
    },
    [REQUESTS.UPSERT_SETTINGS]: {
        method: REQUEST_METHOD.POST,
        api: 'settings/upsert',
    },
};
