import React from 'react';

import { useRequestHandler } from '../../../../hooks/useRequestHandler';
import { Button } from '../../../../ui/Button';
import { Window } from '../../../../ui/FullModal';
import { Link } from '../../../../ui/Link';
import { NoInformation } from '../../../../ui/NoInformation';
import { Request2 } from '../../../../utils/request';
import { FormConstructor } from '../../../FormConstructor';
import { SimpleError } from '../../../SimpleError';
import Spin from '../../../Spin';
import style from './index.css';
import { requestConfigs, REQUESTS } from './request';

export default class IVRSettings extends React.Component<any, any> {
    state = {
        isLoading: false,
        error: null,
        applications: [],
        selectedItem: null,
        isWorking: false,
    };
    request = new Request2({ requestConfigs });

    componentDidMount() {
        this.getData();
    }

    getData() {
        this.setState({
            isLoading: true,
        }, () => {
            this.request.exec(REQUESTS.GET_IVR)
                .then(response => {
                    this.setState({
                        applications: response?.applications || [],
                        isLoading: false,
                        error: null,
                    });
                }).catch(error => {
                    this.setState({
                        isLoading: false,
                        error,
                    });
                });
        });

    }

    select(selectedItem) {
        this.setState({
            selectedItem,
        });
    }

    onUpdate(body) {
        this.setState({
            isWorking: true,
        }, () => {
            this.request.exec(REQUESTS.UPDATE, { body })
                .then(() => {
                    this.setState({
                        isWorking: false,
                        selectedItem: null,
                    }, () => {
                        this.getData();
                    });
                })
                .catch(error => {
                    this.setState({
                        error,
                        isWorking: false,
                    });
                });
        });
    }

    render() {
        return <div>
            {
                this.state.error && <SimpleError error={this.state.error}/>
            }
            {
                this.state.isLoading && <Spin size={'s'}/>
            }
            {
                this.state.selectedItem !== null
                && <EditIVR item={this.state.selectedItem}
                            error={this.state.error}
                            isWorking={this.state.isWorking}
                            onUpdate={this.onUpdate.bind(this)}
                            request={this.request}
                            onClose={this.select.bind(this, null)}/>
            }
            {
                this.state.applications?.length
                && <ul>{
                    this.state.applications.map((el: any, index) => {
                        return <li key={index} className={style.item}>
                            {el.application_name} : {el?.actions?.[0]?.action_name} : <Link onClick={this.select
                                .bind(this, el)}>
                                edit
                            </Link>
                        </li>;
                    })
                }</ul>
                || <NoInformation/>
            }
        </div>;
    }
}

const EditIVR = (props) => {
    const options = React.useMemo(() => {
        return {
            requestName: REQUESTS.GET_SCHEMA,
            requestOptions: {
                queryParams: {},
            },
        };
    }, []);
    const [state, setState] = React.useState(null);

    const [isLoading, response, error, makeResponse] = useRequestHandler<any>(props.request, options);

    React.useEffect(() => {
        makeResponse();
    }, []);

    const { application_name, actions } = props.item || {};

    return <Window onClose={props.onClose}
                   title={`Редактирвоание IVR: ${application_name}`}
                   error={error || props.error}>
        {
            isLoading
                ? <Spin/>
                : response?.request_data?.structure
                && <>
                    <FormConstructor schema={response.request_data.structure}
                                     onChange={setState.bind(null)}
                                     initialData={{
                                         application_name,
                                         record: actions?.[0]?.action_name,
                                     }}/>
                    <Button onClick={props.onUpdate?.bind(null, state)} isLoading={props.isWorking}>Обновить</Button>
                </>
        }
    </Window>;
};
