import React from 'react';

import { Button } from '../../../../ui/Button';
import { Window } from '../../../../ui/FullModal';
import SystemAlerts from '../../../InterfaceAdminConfig/SystemAlerts';

export const ManageAlerts = React.memo(() => {
    const [isOpen, open] = React.useState(false);

    return <div>
        <Button onClick={open.bind(null, true)}>Настроить</Button>
        {isOpen
            ? <Window title={'Алерты'} onClose={open.bind(null, false)}>
                <SystemAlerts />
            </Window>
            : null
        }
    </div>;
});
