import React from 'react';

import { ONE_SECOND } from '../../../../constants';
import { Button, ButtonTypes } from '../../../../ui/Button';
import { Collapse } from '../../../../ui/Collapse';
import { Confirm, Window } from '../../../../ui/FullModal';
import * as coreStyle from '../../../../ui/index.css';
import { Link } from '../../../../ui/Link';
import { isValidJSONString } from '../../../../utils/isValidJSONString';
import { Request2 } from '../../../../utils/request';
import { deepCopy } from '../../../../utils/utils';
import { FormConstructor } from '../../../FormConstructor';
import { controlType } from '../../../FormConstructor/types';
import style from './index.css';
import { NOTIFIERS_REQUESTS, REQUESTS } from './request';

const FuckupNotifiers = {
    fuckup_payment: 'fuckup_payment',
    fuckup_ride: 'fuckup_ride',
    fuckup_service: 'fuckup_service',
    wait_support: 'wait_support',
};

export class ManageFuckupNotifiers extends React.Component<any, any> {
    request = new Request2({ requestConfigs: NOTIFIERS_REQUESTS });
    state: any = {
        notifiers: [],
        error: null,
        isLoading: false,
        confirmSwitchOffIsOpen: false,
        selectedNotifier: null,
    };

    switchOn(auditory_condition) {
        const data = deepCopy(this.state.selectedNotifier);
        data.meta.is_common = true;
        data.meta.is_hidden = false;
        data.meta.common_instant = new Date().getTime();
        if (auditory_condition) {
            data.meta.auditory_condition = auditory_condition;
        } else {
            delete data.meta.auditory_condition;
        }

        this.upsert(data);
    }

    upsert(data) {
        const body = {
            objects: [data],
        };
        this.setState({
            isLoading: true,
        }, () => {
            this.request.exec(REQUESTS.UPSERT_NOTIFIERS, { body })
                .then(() => {
                    this.setState({
                        isLoading: false,
                        confirmSwitchOffIsOpen: false,
                        confirmSwitchOnIsOpen: false,
                    }, () => {
                        setTimeout(() => {
                            this.getNotifiers();
                        }, ONE_SECOND);
                    });
                })
                .catch(error => {
                    this.setState({
                        error,
                        isLoading: false,
                    });
                });
        });
    }

    switchOff() {
        const data = deepCopy(this.state.selectedNotifier);
        data.meta.is_common = false;
        data.meta.is_hidden = true;
        this.upsert(data);
    }

    getNotifiers() {
        this.request.exec(REQUESTS.GET_NOTIFIERS, {
            queryParams: { ids: Object.keys(FuckupNotifiers).join(',') },
        }).then(response => {
            this.setState({
                notifiers: response.objects || [],
            });
        });
    }

    componentWillUnmount() {
        this.request.abort();
    }

    componentDidMount() {
        this.getNotifiers();
    }

    confirmSwitchOffIsOpen(confirmSwitchOffIsOpen, selectedNotifier) {
        this.setState({
            confirmSwitchOffIsOpen,
            selectedNotifier,
        });
    }

    confirmSwitchOnIsOpen(confirmSwitchOnIsOpen, selectedNotifier) {
        this.setState({
            confirmSwitchOnIsOpen,
            selectedNotifier,
        });
    }

    render() {
        return <div className={style.component}>
            {
                this.state.confirmSwitchOffIsOpen ?
                    <Confirm title={`${this.state.selectedNotifier?.name}?`}
                             error={this.state.error}
                             isWorking={this.state.isLoading}
                             question={`Выключить нотификатор ${this.state.selectedNotifier?.name}?`}
                             accept={this.switchOff.bind(this)}
                             onClose={this.confirmSwitchOffIsOpen.bind(this, false, null)}/> : null
            }
            {
                this.state.confirmSwitchOnIsOpen ?
                    <SwitchOnModal isWorking={this.state.isLoading}
                                   notifier={this.state.selectedNotifier}
                                   onClose={this.confirmSwitchOnIsOpen.bind(this, false, null)}
                                   error={this.state.error}
                                   accept={this.switchOn.bind(this)}/>
                    : null
            }
            <ul>
                {
                    this.state.notifiers.map((notifier: any) => {
                        return <NotiferItem item={notifier}
                                            key={`${notifier.name}-${notifier.revision}`}
                                            switchOn={this.confirmSwitchOnIsOpen.bind(this, true, notifier)}
                                            switchOff={this.confirmSwitchOffIsOpen.bind(this, true, notifier)}/>;
                    })
                }
            </ul>
        </div>;
    }
}

const scheme = {
    'auditory_condition': {
        'type': controlType.text,
        default: '',
        'display_name': 'Аудитория для общих чатов',
        'order': 1,
    },
};

const SwitchOnModal = React.memo((props: { error; notifier; onClose; accept; isWorking }) => {
    const name = props.notifier?.name;
    const auditory_condition_string = JSON.stringify(props.notifier?.meta?.auditory_condition) || '';
    const [auditory_condition, setCondition] = React.useState(auditory_condition_string);
    const [isValidData, setIsValid] = React.useState(false);
    const onChange = (meta) => {
        let value: any = null;
        if (!meta?.auditory_condition?.length) {
            setIsValid(true);
        } else if (isValidJSONString(meta.auditory_condition)) {
            value = JSON.parse(meta.auditory_condition);
            setIsValid(true);
        } else {
            setIsValid(false);
        }

        setCondition(value);
    };

    return <Window title={`${name}`} error={props.error} onClose={props.onClose}>
        <div>Включить нотификатор <strong>{name}</strong></div>
        <FormConstructor schema={scheme}
                         initialData={{ auditory_condition: auditory_condition_string }}
                         onChange={onChange}/>
        <Collapse title={'пример заполнения параметра "Аудитория для общих чатов"'} collapsed>
            <pre>
                {'{\n\t"name": "global_SPB",\n\t"type": "in_area"\n}'}
            </pre>
        </Collapse>
        <div className={`${coreStyle.button_container} ${coreStyle.full_width}`}>
            <Button colorType={ButtonTypes.negative} onClick={props.onClose}>Отмена</Button>
            <Button colorType={ButtonTypes.positive}
                    onClick={props.accept.bind(null, auditory_condition)}
                    disabled={!isValidData}
                    isLoading={props.isWorking}>Включить</Button>
        </div>
    </Window>;
});

const NotiferItem = React.memo((props: { item: any; switchOn: any; switchOff: any }) => {
    const { switchOn, switchOff, item } = props;
    const { is_common } = item?.meta || {};

    return <li className={`${style.item} ${is_common ? style.is_common : ''}`}>
        <span className={style.marker}/>
        <span className={style.title}>{props?.item?.meta?.title}</span>
        {is_common ?
            <span className={style.control}><Link onClick={switchOff}>выкл</Link></span>
            : <span className={style.control}><Link onClick={switchOn}>вкл</Link></span>
        }
    </li>;
});
