import { IComponentRequest, REQUEST_METHOD } from '../../../../utils/request';

export const REQUESTS = {
    GET_NOTIFIERS: 'GET_NOTIFIERS',
    UPSERT_NOTIFIERS: 'UPSERT_NOTIFIERS',
};

const NOTIFIERS_REQUESTS: IComponentRequest = {
    [REQUESTS.GET_NOTIFIERS]: {
        api: 'notifiers/info',
        cgiObj: {
            ids: null,
        },
    },[REQUESTS.UPSERT_NOTIFIERS]: {
        method: REQUEST_METHOD.POST,
        api: 'notifiers/upsert',
    },
};

export { NOTIFIERS_REQUESTS };
