import React from 'react';

import { Link } from '../../../../ui/Link';
import { NoInformation } from '../../../../ui/NoInformation';
import * as tblStyle from '../../../../ui/Table/index.css';
import { Request2 } from '../../../../utils/request';
import { IPolygonItem } from '../../../Settings/Polygons/component';
import { SimpleError } from '../../../SimpleError';
import Spin from '../../../Spin';
import TagModal from '../../../TagModal';
import { OBJECT_TYPES, Operations } from '../../../TagModal/component';
import { POLYGON_PHONES_REQUESTS as requestConfigs, REQUESTS } from './request';

interface IPolygonPhones {
    isLoading: boolean;
    error: null | Error;
    areas: IPolygonItem[];
    editingPoly: IPolygonItem | null;
}

const AREA_PHONE_TAG = 'common_area_user_info';

export class PolygonPhones extends React.Component<any, IPolygonPhones> {
    request = new Request2({
        requestConfigs,
    });
    state: IPolygonPhones = {
        isLoading: false,
        error: null,
        areas: [],
        editingPoly: null,
    };

    getAreas() {
        this.setState({
            isLoading: true,
            error: null,
        }, () => {
            this.request.exec(REQUESTS.AREAS_INFO)
                .then(response => {
                    const areas: IPolygonItem[] = response?.areas?.filter?.((polygon: IPolygonItem) => {
                        return polygon?.hard_tags?.some?.(item => item.tag === AREA_PHONE_TAG);
                    });

                    this.setState({
                        error: null,
                        areas,
                        isLoading: false,
                    });

                })
                .catch(error => {
                    this.setState({
                        error,
                        isLoading: false,
                    });
                });
        });
    }

    componentDidMount() {
        this.getAreas();
    }

    componentWillUnmount() {
        this.request.abort();
    }

    edit(editingPoly: IPolygonItem) {
        this.setState({
            editingPoly,
        });
    }

    getPhoneTag(tags) {
        return tags?.find?.(tag => tag.tag === AREA_PHONE_TAG);
    }

    getPhone(tag) {
        return tag?.infos?.map((info, index) => <div key={index}>{info.value}</div>);
    }

    render() {
        return <div>
            {this.state.editingPoly
                ? <TagModal objectId={{ type: OBJECT_TYPES.AREA, id: this.state.editingPoly.area_id || '' }}
                            operation={Operations.EDIT}
                            initialData={this.getPhoneTag(this.state.editingPoly.hard_tags)}
                            onClose={this.edit.bind(this, null)}/>
                : null}
            {
                this.state.isLoading
                    ? <Spin/> : this.state.error
                        ? <SimpleError error={this.state.error}/> :
                        this.state.areas.length ? <table className={tblStyle.table}>
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>полигон</th>
                                    <th>инфо</th>
                                    <th/>
                                </tr>
                            </thead>
                            <tbody>
                                {
                                    this.state.areas.map((item, index) => {
                                        const phoneTag = this.getPhoneTag(item.hard_tags);

                                        return <tr key={item.area_id}>
                                            <td>{index + 1}</td>
                                            <td>{item.area_id}{item.area_title ? ` / ${item.area_title}` : ''}</td>
                                            <td>{this.getPhone(phoneTag)}</td>
                                            <td><Link onClick={this.edit.bind(this, item)}>
                                                поправить телефончик
                                            </Link></td>
                                        </tr>;
                                    })
                                }
                            </tbody>
                        </table>
                            : <NoInformation/>
            }
        </div>;
    }
}
