import React from 'react';

import { ONE_HUNDRED_PERCENT } from '../../../../constants';
import { Button } from '../../../../ui/Button';
import FormatDate from '../../../../ui/FormatDate';
import { Confirm } from '../../../../ui/FullModal';
import tblStyle from '../../../../ui/Table/index.css';
import { Request2 } from '../../../../utils/request';
import { SimpleError } from '../../../SimpleError';
import Spin from '../../../Spin';
import style from './index.css';
import { HITMAN_REQUESTS, REQUESTS } from './request';

interface IRunHitmanFuckupAlertProps {
    yandex_login: string;
}

export class RunHitmanFuckupAlert extends React.Component<IRunHitmanFuckupAlertProps> {
    state = {
        confirmIsOpen: false,
        error: null,
        isLoading: false,
        history: [],
        historyIsLoading: true,
        historyError: null,
    };
    request = new Request2({ requestConfigs: HITMAN_REQUESTS });

    showConfirm(confirmIsOpen) {
        this.setState({
            confirmIsOpen,
        });
    }

    getHistory() {
        this.request.exec(REQUESTS.GET_HITMAN_TASK_STATUS)
            .then(history => {
                this.setState({
                    history,
                    historyIsLoading: false,
                });
            }).catch(historyError => {
                this.setState({
                    historyError,
                    historyIsLoading: false,
                });
            });
    }

    run() {
        this.setState({
            isLoading: true,
        }, () => {
            this.request.exec(REQUESTS.RUN_HITMAN_TASK, {
                body: {
                    requester: this.props.yandex_login,
                    properties: {},
                    comment: 'Через интерфейс админки',
                },
            })
                .then(() => {
                    this.setState({
                        isLoading: false,
                        confirmIsOpen: false,
                    }, () => {
                        this.getHistory();
                    });
                })
                .catch(error => {
                    this.setState({
                        error,
                        isLoading: false,
                    });
                });
        });
    }

    componentDidMount() {
        this.getHistory();
    }

    componentWillUnmount() {
        this.request.abort();
    }

    render() {
        return <div className={style.hitman}>
            {
                this.state.confirmIsOpen
                    ? <Confirm question={'Действительно вызвать?'}
                               error={this.state.error}
                               isWorking={this.state.isLoading}
                               onClose={this.showConfirm.bind(this, false)}
                               accept={this.run.bind(this)}/>
                    : null
            }
            <Button onClick={this.showConfirm.bind(this, true)}>Hitman alert</Button>
            {
                this.state.historyError ? <SimpleError error={this.state.historyError}/> : null
            }
            {
                this.state.historyIsLoading ? <Spin/>
                    : <table className={tblStyle.table}>
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>createdDateTime</th>
                                <th>updatedDateTime</th>
                                <th>comment</th>
                                <th>progress</th>
                                <th>status</th>
                                <th>requester</th>
                            </tr>
                        </thead>
                        <tbody>
                            {
                                Array.isArray(this.state.history) && this.state.history.map((el: any, index) => {
                                    return <tr key={el.id}>
                                        <td>{index + 1}</td>
                                        <td><FormatDate value={el.createdDateTime} withSecond/></td>
                                        <td><FormatDate value={el.updatedDateTime} withSecond/></td>
                                        <td>{el.comment}</td>
                                        <td>{Math.floor(el.progress * ONE_HUNDRED_PERCENT)}%</td>
                                        <td>{el.status}</td>
                                        <td>{el.requester}</td>
                                    </tr>;
                                })
                            }
                        </tbody>
                    </table>
            }
        </div>;
    }
}
