import React, { useState } from 'react';

import { useRequestHandler } from '../../../../hooks/useRequestHandler';
import { Button, ButtonTypes } from '../../../../ui/Button';
import { Window } from '../../../../ui/FullModal';
import { Request2 } from '../../../../utils/request';
import { SimpleError } from '../../../SimpleError';
import { INCIDENT_REQUESTS, REQUESTS } from '../request';

interface IIncidentAttachPhotoProps {
    onClose: () => void;
    tags: Record<string, any>[];
    incident_id: string;
    photoIds: string[];
    tagWasCreated: boolean;
}

export const IncidentAttachPhoto = React.memo((props: IIncidentAttachPhotoProps) => {
    const { onClose, tags, incident_id, photoIds, tagWasCreated } = props;
    const request = new Request2({ requestConfigs: INCIDENT_REQUESTS });

    const [actions, setActions] = useState<any>(null);

    const requestOptions = React.useMemo(() => {
        return {
            requestName: REQUESTS.PERFORM_INCIDENTS,
            requestOptions: {
                body: {
                    transition: {
                        transition_id: 'handle_attached_photos',
                        actions,
                    },
                    incident_id,
                },
            },
        };
    }, [actions]);

    const tagRequestOptions = React.useMemo(() => {
        return {
            requestName: REQUESTS.DELETE_CAR_TAG,
            requestOptions: {
                queryParams: {
                    tag_id: tags[0]?.tag_id,
                },
            },
        };
    }, [tags?.[0]?.tag_id]);

    const responseHandler = () => {
        if (tagWasCreated) {
            makeTagRequest();
        }
    };

    const [isLoading, , error, makeRequest] = useRequestHandler(request, requestOptions ?? {}, responseHandler);
    const [isTagLoading, , tagError, makeTagRequest] = useRequestHandler(request, tagRequestOptions ?? {});

    React.useEffect(() => {
        if (photoIds && tags && incident_id) {
            const attachment_code = tags[0]?.tag === 'dtp_flow_photo_document' ? 'C080' : 'I190';

            const actions = photoIds?.map(image_id => {
                return {
                    action_type: 'upsert',
                    attachment_code,
                    image_id,
                };
            });

            actions.length && setActions(actions);
            actions.length && makeRequest();
        }
    }, [incident_id]);

    return <Window onClose={onClose.bind(null)}>
        {isLoading
            ? <div>Прикрепляем фото к инциденту...</div>
            : error
                ? <div>
                    Не удалось прикрепить фото
                    <SimpleError error={error}/>
                </div>
                : <div>
                    <h4>Фото прикреплены</h4>
                </div>
        }

        {tagWasCreated
            ? isTagLoading
                ? <div>Закрываем тег...</div>
                : tagError
                    ? <div>
                        Не удалось закрыть тег
                        <SimpleError error={tagError}/>
                    </div>
                    : <h4>Тег успешно закрыт</h4>
            : null
        }

        <br/>

        <Button colorType={ButtonTypes.positive}
                onClick={onClose.bind(null)}>
            OK
        </Button>
    </Window>;
});
