import { IComponentRequest, REQUEST_METHOD } from '../../../utils/request';

export enum REQUESTS {
    GET_INCIDENTS = 'GET_INCIDENTS',
    GET_PERFORM_INCIDENTS_SCHEMA = 'GET_PERFORM_INCIDENTS_SCHEMA',
    PERFORM_INCIDENTS = 'PERFORM_INCIDENTS',
    GET_CREATE_INCIDENTS_SCHEMA = 'GET_CREATE_INCIDENTS_SCHEMA',
    CREATE_INCIDENT = 'CREATE_INCIDENT',
    GET_PHOTOS = 'GET_PHOTOS',
    REGISTER_INCIDENT_PHOTO = 'REGISTER_INCIDENT_PHOTO',
    GET_CAR_TAGS = 'GET_CAR_TAGS',
    UPLOAD_INCIDENT_PHOTO = 'UPLOAD_INCIDENT_PHOTO',
    DELETE_CAR_TAG = 'DELETE_CAR_TAG',
    GET_CAR_INFO = 'GET_CAR_INFO',
    GET_INCIDENTS_SETTINGS = 'GET_INCIDENTS_SETTINGS',
    ATTACH_USER_TAG = 'ATTACH_USER_TAG',
    GET_SESSION = 'GET_SESSION',
}

export const INCIDENT_REQUESTS: IComponentRequest = {
    [REQUESTS.GET_INCIDENTS]: {
        api: 'incident/list',
        cgiObj: {
            car_id: null,
            session_id: null,
            user_id: null,
            incident_id: null,
            since: null,
            until: null,
            limit: null,
            offset: null,
        },
    },
    [REQUESTS.GET_PERFORM_INCIDENTS_SCHEMA]: {
        api: 'incident/perform_transition',
        cgiObj: {
            scheme: null,
            incident_id: null,
        },
    },
    [REQUESTS.PERFORM_INCIDENTS]: {
        api: 'incident/perform_transition',
        method: REQUEST_METHOD.POST,
    },
    [REQUESTS.GET_CREATE_INCIDENTS_SCHEMA]: {
        api: 'incident/create',
        cgiObj: {
            scheme: null,
        },
    },
    [REQUESTS.CREATE_INCIDENT]: {
        api: 'incident/create',
        method: REQUEST_METHOD.POST,
    },
    [REQUESTS.GET_PHOTOS]: {
        api: 'incident/photo/list',
        cgiObj: {
            since: null,
            until: null,
            car_id: null,
        },
    },
    [REQUESTS.REGISTER_INCIDENT_PHOTO]: {
        method: REQUEST_METHOD.POST,
        api: 'incident/photo/register',
    },
    [REQUESTS.GET_CAR_TAGS]: {
        api: 'car/tag/list',
        cgiObj: {
            car_id: null,
        },
    },
    [REQUESTS.UPLOAD_INCIDENT_PHOTO]: {
        method: REQUEST_METHOD.POST,
        api: 'incident/photo/upload',
        cgiObj: {
            car_id: null,
            photo_id: null,
        },
    },
    [REQUESTS.DELETE_CAR_TAG]: {
        api: 'car/tag/remove',
        cgiObj: {
            tag_id: null,
        },
    },
    [REQUESTS.GET_CAR_INFO]: {
        api: 'car/info',
        cgiObj: {
            car_id: null,
        },
    },
    [REQUESTS.GET_INCIDENTS_SETTINGS]: {
        api: 'settings/info',
        cgiObj: {
            prefix: null,
        },
    },
    [REQUESTS.ATTACH_USER_TAG]: {
        method: REQUEST_METHOD.POST,
        api: 'user_tags/add',
        cgiObj: {
            report_tag_info: null,
        },
    },
    [REQUESTS.GET_SESSION]: {
        api: 'sessions/history',
        cgiObj: {
            session_id: null,
        },
    },
};
