import { Dict } from '../../../../types';

export enum INCIDENT_LINK {
    DOCUMENT = 'document',
    PHOTO = 'photo',
    TAG = 'tag',
    STARTREK_TICKET = 'startrek_ticket',
}

export interface IIncidentLink {
    //common
    type: INCIDENT_LINK;
    last_modified: number;
    originator_id: string;
    comment: string;
    //document
    attachment_code?: string; //for photo too
    document_id?: string;
    document_type?: string;
    document_url?: string;
    //photo
    image_id?: string;
    image_url?: string;
    marker?: string;
    attachment_code_description?: string;
    //tag
    tag_id?: string;
    tag_entity_type?: string;
    //startrek_ticket
    ticket_key?: string;
    ticket_url?: string;
}

export interface IIncident {
    incident_id: string;
    initiated_at: number;
    incident_type: string;
    incident_status: string;
    session_id: string;
    car_id: string;
    user_id: string;
    contexts: Dict<any>[];
    links: IIncidentLink[];
    carInfo?: Dict<any> | null;
    sessionInfo?: Dict<any> | null;
    userInfo?: Dict<any> | null;
    images?: Dict<Dict<any>[]>;
}
