import { Dict } from '../../../../types';

export interface ILongtermOffersData {
    accounts: any[];
    cars: any[];
    clusters: any[];
    defaults: Dict<any>;
    models: Dict<any>;
    distributing_block: Dict<any>;
    filters: any[];
    localizations: Dict<any>;
    notifications: any[];
    offers: any[];
    payment_methods: any[];
    poi: any[];
    property_patches: any[];
    sf: any[];
    transportation: {};
    views: any[];
    visibility: any[];
    debug_session_info: {
        long_term_autohide: IDebugInfoItem[];
    };
}

export interface IDebugInfoItem {
    "name": string;
    "hide": boolean;
    "score": number;
    "tier1": number;
    "tier2": number;
    "existing": number;
    "event": string;
}

export interface IOfferInfo {
    available_since: number;
    available_until: number;
    badges: any[];
    behaviour_constructor_id: string;
    car_description: string;
    constructor_id: string;
    deadline: number;
    debt: {threshold: 0};
    detailed_description: string;
    device_id: string;
    duration: number;
    extension: number;
    extras: any [];
    filters: number [];
    finish_instant: number;
    from_scanner: boolean;
    group_name: string;
    is_corp_session: false;
    is_plus_user: false;
    list_priority: number;
    localizations: Dict<any>;
    maximal_period: number;
    maximal_since: number;
    mileage_limit: number;
    minimal_period: number;
    monthly_cost: number;
    name: string;
    new: false;
    object_model: string;
    offer_id: string;
    offer_image: string;
    offer_image_style: string;
    offer_small_image: string;
    overrun_price: number;
    overtime_price: number;
    pack_price: number;
    pack_price_undiscounted: number;
    parent_id: string;
    payment_methods: any[];
    payment_plan: Dict<any>;
    prebill: any[];
    price_constructor_id: string;
    prices: Dict<any>;
    primary: any[];
    rerun_price_km: number;
    secondary: any[];
    short_description: any[];
    since: number;
    start_instant: number;
    subname: string;
    type: string;
    until: number;
    visual: Dict<any>;
    wallets: any[];
    weekly_cost: number;
}

export const LONGTERM_BUILDER = 'long_term_offer_builder';
export const CITY_TAG = 'metafilter_long_term_city';
export const CLASS_TAG = 'metafilter_long_term_class';

export enum OFFERS_FILTERS {
    newCar = 'newCar',
    city = 'city',
    carClass = 'carClass',
}
