import { API_PREFIXES, IComponentRequest, REQUEST_METHOD } from '../../../utils/request';

export enum REQUESTS {
    GET_REQUEST_AGGREGATOR = 'GET_REQUEST_AGGREGATOR',
    GET_REQUEST_TAGS_CATEGORIES = 'GET_REQUEST_TAGS_CATEGORIES',
    GET_REQUEST_TAGS = 'GET_REQUEST_TAGS',
    GET_REQUEST_TAGS_CATEGORIES_ASSIGN = 'GET_REQUEST_TAGS_CATEGORIES_ASSIGN',
    REMOVE_REQUEST_TAGS = 'REMOVE_REQUEST_TAGS',
    GET_CLASSIFICATION_TREE = 'GET_CLASSIFICATION_TREE',
}

export const CORE_DRIVE_LENS_REQUESTS: IComponentRequest = {
    [REQUESTS.GET_REQUEST_AGGREGATOR]: {
        apiPrefix: API_PREFIXES._OLD_PY_REQUEST_AGGREGATOR,
        api: 'aggregated/requests/',
        cgiObj: {
            agent_username: null,
            uid: null,
            user_id: null,
            agent_user_id: null,
            since: null,
            until: null,
            next_cursor: null,
        },
    },
    [REQUESTS.GET_REQUEST_TAGS_CATEGORIES]: {
        apiPrefix: API_PREFIXES._OLD_PY_REQUEST_AGGREGATOR,
        api: 'tags/categories/',
        cgiObj: {
            request_origin: null,
            tag_type: null,
        },
    },
    [REQUESTS.GET_REQUEST_TAGS]: {
        apiPrefix: API_PREFIXES._OLD_PY_REQUEST_AGGREGATOR,
        api: 'tags/',
        cgiObj: {
            request_origin: null,
            request_id: null,
        },
    },
    [REQUESTS.GET_REQUEST_TAGS_CATEGORIES_ASSIGN]: {
        apiPrefix: API_PREFIXES._OLD_PY_REQUEST_AGGREGATOR,
        method: REQUEST_METHOD.POST,
        api: 'tags/assign/',
    },
    [REQUESTS.REMOVE_REQUEST_TAGS]: {
        apiPrefix: API_PREFIXES._OLD_PY_REQUEST_AGGREGATOR,
        method: REQUEST_METHOD.POST,
        api: 'tags/remove/',
    },
    [REQUESTS.GET_CLASSIFICATION_TREE]: {
        apiPrefix: API_PREFIXES._OLD_PY_KNOW_BASE,
        api: 'categories/tree/',
        cgiObj: {
            filter: null,
        },
    },
};
