import React from 'react';

import { Dict } from '../../../../../types';
import FormatDate from '../../../../ui/FormatDate';
import { Link } from '../../../../ui/Link';
import { NoInformation } from '../../../../ui/NoInformation';
import * as tblStyle from '../../../../ui/Table/index.css';
import CarNumber from '../../../CarNumber';
import { IRichCarEvac } from '../component';
import * as styles from '../index.css';

interface ITableCars {
    currentCarsService: Dict<IRichCarEvac[]>;
    currentCarsOther: IRichCarEvac[];
}

const MEDIUM_PRIORITY = 500;
const HIGH_PRIORITY = 1000;
const TASK_LINK_LIMIT = 26;

export const TableCars = ((props: ITableCars) => {
    const { currentCarsService, currentCarsOther } = props;
    const currentCarsServiceKeys = Object.keys(currentCarsService);

    return <>
        <div className={styles.block}>
            <h4>На штрафстоянке и не в service</h4>
            {!currentCarsOther?.length
                ? <NoInformation/>
                : <table className={tblStyle.table}>
                    <thead>
                        <tr className={'header'}>
                            <th>#</th>
                            <th>Номер машины</th>
                            <th>Модель</th>
                            <th>Время попадания в полигон</th>
                            <th>Оффер</th>
                            <th>Ссылка на сессии машины</th>
                        </tr>
                    </thead>
                    <tbody>
                        {
                            currentCarsOther.map((car, index) => {
                                return (
                                    <TrCarOther car={car}
                                                key={index}
                                                index={index}/>
                                );
                            })
                        }
                    </tbody>
                </table>
            }
        </div>
        <div className={styles.block}>
            <h4>На штрафстоянке и в service</h4>
            {!currentCarsServiceKeys?.length
                ? <NoInformation/>
                : currentCarsServiceKeys.map((key, index) => {
                    return (
                        <div key={index}
                             className={styles.block}>
                            <h5>{currentCarsServiceKeys[index]}</h5>
                            {!currentCarsService[key]?.length
                                ? <NoInformation/>
                                : <table className={tblStyle.table}>
                                    <thead>
                                        <tr className={'header'}>
                                            <th>#</th>
                                            <th>Номер машины</th>
                                            <th>Модель</th>
                                            <th>Теги (автор тега)</th>
                                            <th>Дата тега</th>
                                            <th>Ссылка на таск</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        {
                                            currentCarsService[key].map((car, index) => {
                                                return (
                                                    <TrCarService car={car}
                                                                  key={index}
                                                                  index={index}/>
                                                );
                                            })
                                        }
                                    </tbody>
                                </table>
                            }
                        </div>
                    );
                })
            }
        </div>
    </>;
});

interface TrCarProps {
    car: any;
    index: number;
}

const TrCarOther = ((props: TrCarProps) => {
    const { car, index } = props;

    return (
        <tr>
            <td>{index + 1}</td>
            {/*Car plates*/}
            <td>
                <CarNumber carInfo={car}/>
            </td>
            {/*Car model*/}
            <td>
                <Link href={`#/cars/${car.id}/info`} target="_blank">{car.model_id}</Link>
            </td>
            {/*Car 1st time in poly*/}
            <td>
                <FormatDate value={car.incorrectMovingTime}
                            className={styles.tag_date}
                            withSecond/>
            </td>
            {/*Offer*/}
            <td>
                <strong>{car.offer_group_name}</strong> {car.offer_name}
            </td>
            {/*Last user session*/}
            <td>
                <Link href={`#/cars/${car.id}/sessions`} target="_blank">info</Link>
            </td>
        </tr>
    );
});

const TrCarService = ((props: TrCarProps) => {
    const { car, index } = props;

    return (
        <tr>
            <td>{index + 1}</td>
            <td>
                <CarNumber carInfo={car}/>
            </td>
            <td>
                <Link href={`#/cars/${car.id}/info`} target='_blank'>{car.model_id}</Link>
            </td>
            <td>
                <div className={styles.serviceCarTags}>
                    {car.current_tags && Array.isArray(car.current_tags) && car.current_tags
                        .filter((tag) => tag.priority === MEDIUM_PRIORITY || tag.priority === HIGH_PRIORITY)
                        .map((tag, key) => {
                            return (
                                <span className={styles.tag} key={key}>
                                    <span className={styles.priority}>{tag.priority}: </span>
                                    <span className={styles.tag_name}>
                                        {tag.tagName}&nbsp;
                                        <Link href={tag.authorLink} target='_blank'>
                                            {tag.tagAuthor}
                                        </Link>
                                    </span>
                                </span>
                            );
                        })
                    }
                </div>
            </td>
            {/*Tag date*/}
            <td>
                {car.tagDate && car.tagDate.map((date, key) => {
                    return (
                        <FormatDate className={styles.tag_date}
                                    key={key}
                                    value={date}
                                    withSecond/>
                    );
                })
                }
            </td>
            {/*Task link*/}
            <td>
                {car.taskLink ? (
                    <Link href={car.taskLink} target='_blank'>{car.taskLink.substr(TASK_LINK_LIMIT)}</Link>
                ) : (
                    <span>-</span>
                )}
            </td>
        </tr>
    );
});
