import { API_PREFIXES, combineRequests, IComponentRequest, REQUEST_METHOD } from '../../utils/request';
import { requestConfigs, REQUESTS as CHAT_REQUESTS_OBJ } from '../ChatsCommon/request';

export const REQUESTS: { [key: string]: string } = combineRequests({
    GET_TAGS: 'GET_TAGS',
    UPDATE_TAG: 'UPDATE_TAG',
    GET_CARS: 'GET_CARS',
    GET_CAR_TAG_HISTORY: 'GET_CAR_TAG_HISTORY',
    GET_DEVICES: 'GET_DEVICES',
    GET_LOAD_BALANCE: 'GET_LOAD_BALANCE',
    SET_LOAD_BALANCE: 'SET_LOAD_BALANCE',
    ARCHIVE: 'ARCHIVE',
    GET_OFFERS: 'GET_OFFERS',
    GET_GLOBAL_SETTINGS: 'GET_GLOBAL_SETTINGS',
    UPSERT_SETTINGS: 'UPSERT_SETTINGS',
}, { [CHAT_REQUESTS_OBJ.SET_PERFORM]: CHAT_REQUESTS_OBJ.SET_PERFORM });

const SUPPORT_REQUESTS: IComponentRequest = combineRequests({
    [REQUESTS.GET_TAGS]: {
        api: 'tags/search',
        cgiObj: {
            has_one_of: '@user_alert_tag',
        },
    },
    [REQUESTS.UPDATE_TAG]: {
        method: REQUEST_METHOD.POST,
        api: 'user_tags/update',
    },
    [REQUESTS.GET_CARS]: {
        api: 'car/list',
        cgiObj: {
            traits: null,
            car_id: null,
            antitraits: null,
            filters: null,
        },
    },
    [REQUESTS.GET_CAR_TAG_HISTORY]: {
        api: 'car/tag/history',
        cgiObj: {
            car_id: null,
            duration: '7d',
        },
    },
    [REQUESTS.GET_DEVICES]: {
        api: 'devices/list',
        cgiObj: {
            user_id: null,
        },
    },
    [REQUESTS.GET_LOAD_BALANCE]: {
        api: 'call/settings/load_balance_calendar/',
        apiPrefix: API_PREFIXES._OLD_PY_V1,
        cgiObj: {
            city: null,
        },
    },
    [REQUESTS.SET_LOAD_BALANCE]: {
        api: 'call/settings/load_balance_calendar/',
        apiPrefix: API_PREFIXES._OLD_PY_V1,
        method: REQUEST_METHOD.POST,
    },
    [REQUESTS.ARCHIVE]: {
        api: 'support/requests',
        cgiObj: {
            tags: '@user_support_call_tag,@user_outgoing_communication',
            rev: 'true',
            since: null,
            limit: 2000,
        },
    },
    [REQUESTS.GET_OFFERS]: {
        api: 'offers/create',
        method: REQUEST_METHOD.POST,
        cgiObj: {
            offer_builder_type: null,
            offer_name: null,
        },
    },
    [REQUESTS.GET_GLOBAL_SETTINGS]: {
        api: 'settings/info',
        cgiObj: {
            prefix: null,
        },
    },
    [REQUESTS.UPSERT_SETTINGS]: {
        method: REQUEST_METHOD.POST,
        api: 'settings/upsert',
    },
}, { [CHAT_REQUESTS_OBJ.SET_PERFORM]: requestConfigs[CHAT_REQUESTS_OBJ.SET_PERFORM] });

export { SUPPORT_REQUESTS };
