import React from 'react';

import { ONE_MINUTE } from '../../constants';
import { Cross } from '../../ui/Cross';
import { isObjectEqual } from '../../utils/isObjectEqual';
import { ISystemAlertItem } from '../InterfaceAdminConfig/SystemAlerts/schema';
import style from './index.css';

interface ISystemAlertsContainerState {
    alerts: ISystemAlertItem[];
}

export class SystemAlertsContainer extends React.Component<any, ISystemAlertsContainerState> {
    state: ISystemAlertsContainerState = {
        alerts: [],
    };
    timer;

    componentDidMount() {
        this.getAlerts();
    }

    componentDidUpdate(prevProps: Readonly<any>, prevState: Readonly<any>, snapshot?: any) {
        if (!isObjectEqual(prevProps, this.props)) {
            this.setState({
                alerts: this.props.alerts,
            });
        }
    }

    getAlerts() {
        clearTimeout(this.timer);
        this.timer = setTimeout(() => {
            this.props.getAlerts();
            this.getAlerts();
        }, ONE_MINUTE);
    }

    close(alert) {
        this.setState((prev) => {
            return {
                alerts: prev.alerts.filter(item => item.text !== alert.text),
            };
        });
    }

    render() {
        return <div className={`${style.system_alerts_container} ${!this.state.alerts.length ? style.empty : ''}`}>
            {
                this.state.alerts
                    .filter((alert: ISystemAlertItem) => alert.enabled)
                    .map((alert: ISystemAlertItem, index) => {
                        return <AlertItem key={index} alert={alert} onClose={this.close.bind(this, alert)}/>;
                    })
            }

        </div>;
    }
}

interface IAlertItemProps {
    alert: ISystemAlertItem;
    onClose: () => void;
}

const AlertItem = React.memo((props: IAlertItemProps) => {
    const { alert, onClose } = props;

    return <div className={`${style.system_alerts_container_item} ${style[alert.type]}`}>
        <div>
            <strong>{alert.title}</strong>: <span>{alert.text}</span>
        </div>
        <Cross className={style.cross} onClick={onClose}/>
    </div>;
});
