import { connect } from 'react-redux';

import { getActuality } from '../../constants';
import { updateAlerts } from '../../reducers/adminUserReducer';
import { isValidJSONString } from '../../utils/isValidJSONString';
import { API_PREFIXES, Request2 } from '../../utils/request';
import { IStore } from '../App/store';
import { SYSTEM_ALERTS } from '../InterfaceAdminConfig/adminConfigKeys';
import { SystemAlertsContainer } from './component';

export const mapStateToProps = (store: IStore) => {
    return {
        alerts: store.AdminUser?.alerts || [],
    };
};

const ALERTS_INFO = 'ALERTS_INFO';
const requestConfigs = {
    [ALERTS_INFO]: {
        api: 'settings/info',
        apiPrefix: API_PREFIXES.SUPPORT_STAFF,
        cgiObj: {
            prefix: SYSTEM_ALERTS,
            actuality: getActuality(),
        },
    },
};

export function mapDispatchToProps(dispatch: any) {
    return {
        getAlerts: () => {
            const request = new Request2({
                requestConfigs,
            });
            request.exec(ALERTS_INFO).then(response => {
                let data = response?.settings?.[0]?.setting_value;
                if (isValidJSONString(data)) {
                    data = JSON.parse(data);
                } else {
                    data = [];
                }

                dispatch(updateAlerts(data));
            });

        },
    };
}

export default connect(mapStateToProps, mapDispatchToProps)(SystemAlertsContainer);
