import { connect } from 'react-redux';

import { ConstantsKey, fetchConstants } from '../../utils/fetchConstants';
import { IStore } from '../App/store';
import TagModal from './component';

export const mapStateToProps = (store: IStore) => {
    return {
        AdminUser: store.AdminUser,
    };
};

export function mapDispatchToPropsWithFetchIFace(dispatch: any) {
    return {
        constantsIFaceTag: (ids: string) => {
            return fetchConstants([ConstantsKey.IFACE_TAG_IMPLEMENTATIONS], dispatch, true, ids);
        },
    };
}

export default connect(mapStateToProps, mapDispatchToPropsWithFetchIFace)(TagModal);
